/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.route53.domain.ResourceRecordSet;

public class SerializeRRS
implements Function<Object, String> {
    public String apply(Object in) {
        ResourceRecordSet rrs = (ResourceRecordSet)ResourceRecordSet.class.cast(Preconditions.checkNotNull((Object)in, (Object)"rrs"));
        StringBuilder builder = new StringBuilder().append("<ResourceRecordSet>");
        builder.append("<Name>").append(rrs.getName()).append("</Name>");
        builder.append("<Type>").append(rrs.getType()).append("</Type>");
        if (rrs instanceof ResourceRecordSet.RecordSubset) {
            String id = ((ResourceRecordSet.RecordSubset)ResourceRecordSet.RecordSubset.class.cast(rrs)).getId();
            builder.append("<SetIdentifier>").append(id).append("</SetIdentifier>");
        }
        if (rrs instanceof ResourceRecordSet.RecordSubset.Weighted) {
            builder.append("<Weight>").append(((ResourceRecordSet.RecordSubset.Weighted)ResourceRecordSet.RecordSubset.Weighted.class.cast(rrs)).getWeight()).append("</Weight>");
        }
        if (rrs instanceof ResourceRecordSet.RecordSubset.Latency) {
            builder.append("<Region>").append(((ResourceRecordSet.RecordSubset.Latency)ResourceRecordSet.RecordSubset.Latency.class.cast(rrs)).getRegion()).append("</Region>");
        }
        if (rrs.getAliasTarget().isPresent()) {
            builder.append("<AliasTarget>");
            builder.append("<HostedZoneId>").append(((ResourceRecordSet.AliasTarget)rrs.getAliasTarget().get()).getZoneId()).append("</HostedZoneId>");
            builder.append("<DNSName>").append(((ResourceRecordSet.AliasTarget)rrs.getAliasTarget().get()).getDNSName()).append("</DNSName>");
            builder.append("</AliasTarget>");
        } else {
            builder.append("<TTL>").append(rrs.getTTL().or((Object)300)).append("</TTL>");
            builder.append("<ResourceRecords>");
            for (String record : rrs.getValues()) {
                builder.append("<ResourceRecord>").append("<Value>").append(record).append("</Value>").append("</ResourceRecord>");
            }
            builder.append("</ResourceRecords>");
        }
        return builder.append("</ResourceRecordSet>").toString();
    }
}

