/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.util.core.json.BrooklynObjectsJsonMapper;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.commons.lang3.StringUtils;

public class ShellEnvironmentSerializer {
    private ObjectMapper mapper;
    private final Function<Object, Object> resolver;

    public ShellEnvironmentSerializer(ManagementContext mgmt) {
        this(mgmt, null);
    }

    public ShellEnvironmentSerializer(ManagementContext mgmt, Function<Object, Object> resolver) {
        this.mapper = BrooklynObjectsJsonMapper.newMapper(mgmt);
        this.resolver = resolver;
    }

    public String serialize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            String str;
            if (value instanceof DeferredSupplier && this.resolver != null) {
                value = this.resolver.apply(value);
            }
            if (this.isJsonString(str = this.mapper.writeValueAsString(value))) {
                String unescaped = StringEscapes.BashStringEscapes.unwrapBashQuotesAndEscapes((String)str);
                if (unescaped.matches("[A-Za-z0-9 :,./*?!_+^=-]*")) {
                    return unescaped;
                }
                return str;
            }
            return str;
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Map<String, String> serialize(@Nullable Map<?, ?> env) {
        if (env == null) {
            return null;
        }
        HashMap serializedEnv = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : env.entrySet()) {
            String key = this.serializeShellEnv(entry.getKey());
            String value = this.serializeShellEnv(entry.getValue());
            serializedEnv.put(key, value);
        }
        return serializedEnv;
    }

    protected boolean isJsonString(String str) {
        return str.length() > 0 && str.charAt(0) == '\"';
    }

    private String serializeShellEnv(Object value) {
        return StringUtils.defaultString((String)this.serialize(value));
    }
}

