/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.resolve.jackson.CommonTypesSerialization;
import org.apache.brooklyn.util.core.json.BidiSerialization;
import org.apache.brooklyn.util.core.json.ConfigurableSerializerProvider;
import org.apache.brooklyn.util.core.json.DurationSerializer;
import org.apache.brooklyn.util.core.json.ErrorAndToStringUnknownTypeSerializer;
import org.apache.brooklyn.util.core.json.MultimapSerializer;
import org.apache.brooklyn.util.core.json.PossiblyStrictPreferringFieldsVisibilityChecker;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynObjectsJsonMapper {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynObjectsJsonMapper.class);

    public static ObjectMapper newMapper(ManagementContext mgmt) {
        ConfigurableSerializerProvider sp = new ConfigurableSerializerProvider();
        sp.setUnknownTypeSerializer((JsonSerializer<Object>)new ErrorAndToStringUnknownTypeSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializerProvider((DefaultSerializerProvider)sp);
        mapper.setVisibility((VisibilityChecker)new PossiblyStrictPreferringFieldsVisibilityChecker());
        mapper.registerModule((Module)new JavaTimeModule());
        CommonTypesSerialization.apply(mapper, mgmt);
        SimpleModule mapperModule = new SimpleModule("Brooklyn", new Version(0, 0, 0, "ignored", null, null));
        new BidiSerialization.ManagementContextSerialization(mgmt).install(mapperModule);
        new BidiSerialization.EntitySerialization(mgmt).install(mapperModule);
        new BidiSerialization.LocationSerialization(mgmt).install(mapperModule);
        new BidiSerialization.PolicySerialization(mgmt).install(mapperModule);
        new BidiSerialization.EnricherSerialization(mgmt).install(mapperModule);
        new BidiSerialization.FeedSerialization(mgmt).install(mapperModule);
        new BidiSerialization.TaskSerialization(mgmt).install(mapperModule);
        new BidiSerialization.ClassLoaderSerialization(mgmt).install(mapperModule);
        mapperModule.addSerializer(Duration.class, (JsonSerializer)new DurationSerializer());
        mapperModule.addSerializer((JsonSerializer)new MultimapSerializer());
        mapper.registerModule((Module)mapperModule);
        return mapper;
    }

    public static ObjectMapper newDslToStringSerializingMapper(ManagementContext mgmt) {
        ObjectMapper mapper = BrooklynObjectsJsonMapper.newMapper(mgmt);
        SimpleModule module = new SimpleModule("Brooklyn-DSL-ToString");
        if (DslToStringSerialization.BROOKLYN_DSL_INTERFACE != null) {
            new DslToStringSerialization().apply(module);
        } else {
            LOG.debug("No DSL interface defined; will not serialize DSL expressions in this instance");
        }
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static class DslToStringSerialization
    extends CommonTypesSerialization.ObjectAsStringSerializerAndDeserializer {
        public static Class BROOKLYN_DSL_INTERFACE = null;

        public Class getType() {
            return BROOKLYN_DSL_INTERFACE;
        }

        public String convertObjectToString(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            return value.toString();
        }

        public Object convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
            throw new IllegalStateException("DSL deserialization not supported by this serializer");
        }
    }
}

