/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.ssh;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.util.core.internal.ssh.ShellAbstractTool;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.ssh.SshException;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SshAbstractTool
extends ShellAbstractTool
implements SshTool {
    private static final Logger LOG = LoggerFactory.getLogger(SshAbstractTool.class);
    protected final String toString;
    protected final String host;
    protected final String user;
    protected final String password;
    protected final int port;
    protected String privateKeyPassphrase;
    protected String privateKeyData;
    protected File privateKeyFile;
    protected boolean strictHostKeyChecking;
    protected boolean allocatePTY;

    protected SshAbstractTool(AbstractSshToolBuilder<?, ?> builder) {
        super(builder.localTempDir);
        this.host = (String)Preconditions.checkNotNull((Object)builder.host, (Object)"host");
        this.port = builder.port;
        this.user = builder.user;
        this.password = builder.password;
        this.strictHostKeyChecking = builder.strictHostKeyChecking;
        this.allocatePTY = builder.allocatePTY;
        this.privateKeyPassphrase = builder.privateKeyPassphrase;
        this.privateKeyData = builder.privateKeyData;
        String keyFile = null;
        String lastCandidate = null;
        for (String candidate : builder.privateKeyFiles) {
            lastCandidate = candidate.startsWith("~") ? System.getProperty("user.home") + candidate.substring(1) : candidate;
            if (!new File(lastCandidate).exists()) continue;
            keyFile = lastCandidate;
            break;
        }
        if (keyFile == null) {
            if (builder.privateKeyFiles.size() == 1) {
                keyFile = lastCandidate;
            } else if (builder.privateKeyFiles.size() > 1 && this.privateKeyData == null) {
                LOG.trace("None of the key files exist; unlikely for SSH to succeed");
            }
        }
        this.privateKeyFile = keyFile != null ? new File(keyFile) : null;
        Preconditions.checkArgument((this.host.length() > 0 ? 1 : 0) != 0, (Object)"host value must not be an empty string");
        Networking.checkPortValid((Integer)this.port, (String)"ssh port");
        this.toString = String.format("%s@%s:%d", this.user, this.host, this.port);
    }

    public String toString() {
        return this.toString;
    }

    public String getHostAddress() {
        return this.host;
    }

    public String getUsername() {
        return this.user;
    }

    protected SshException propagate(Exception e, String message) throws SshException {
        Exceptions.propagateIfFatal((Throwable)e);
        throw new SshException("(" + this.toString() + ") " + message + ": " + e.getMessage(), e);
    }

    public static abstract class AbstractSshToolBuilder<T extends SshTool, B extends AbstractSshToolBuilder<T, B>> {
        protected String host;
        protected int port = 22;
        protected String user = System.getProperty("user.name");
        protected String password;
        protected String privateKeyData;
        protected String privateKeyPassphrase;
        protected Set<String> privateKeyFiles = Sets.newLinkedHashSet();
        protected boolean strictHostKeyChecking = false;
        protected boolean allocatePTY = false;
        protected File localTempDir = null;

        protected B self() {
            return (B)this;
        }

        public B from(Map<String, ?> props) {
            this.host = ShellAbstractTool.getMandatoryVal(props, SshTool.PROP_HOST);
            this.port = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PORT);
            this.user = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_USER);
            this.password = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_PASSWORD);
            ShellAbstractTool.warnOnDeprecated(props, "privateKey", "privateKeyData");
            this.privateKeyData = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PRIVATE_KEY_DATA);
            this.privateKeyPassphrase = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PRIVATE_KEY_PASSPHRASE);
            ShellAbstractTool.warnOnDeprecated(props, "keyFiles", null);
            String privateKeyFile = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PRIVATE_KEY_FILE);
            if (privateKeyFile != null) {
                this.privateKeyFiles.addAll(Arrays.asList(privateKeyFile.split(File.pathSeparator)));
            }
            this.strictHostKeyChecking = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_STRICT_HOST_KEY_CHECKING);
            this.allocatePTY = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_ALLOCATE_PTY);
            String localTempDirPath = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_LOCAL_TEMP_DIR);
            this.localTempDir = localTempDirPath == null ? null : new File(Os.tidyPath((String)localTempDirPath));
            return this.self();
        }

        public B host(String val) {
            this.host = val;
            return this.self();
        }

        public B user(String val) {
            this.user = val;
            return this.self();
        }

        public B password(String val) {
            this.password = val;
            return this.self();
        }

        public B port(int val) {
            this.port = val;
            return this.self();
        }

        public B privateKeyPassphrase(String val) {
            this.privateKeyPassphrase = val;
            return this.self();
        }

        @Deprecated
        public B privateKey(String val) {
            this.privateKeyData = val;
            return this.self();
        }

        public B privateKeyData(String val) {
            this.privateKeyData = val;
            return this.self();
        }

        public B privateKeyFile(String val) {
            this.privateKeyFiles.add(val);
            return this.self();
        }

        public B localTempDir(File val) {
            this.localTempDir = val;
            return this.self();
        }

        public abstract T build();
    }

    public static interface SshAction<T> {
        public void clear() throws Exception;

        public T create() throws Exception;
    }
}

