/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Changeable;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.AbstractGroupImpl;
import org.apache.brooklyn.entity.group.DynamicFabric;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFabricImpl
extends AbstractGroupImpl
implements DynamicFabric {
    private static final Logger logger = LoggerFactory.getLogger(DynamicFabricImpl.class);

    @Override
    public void init() {
        super.init();
        this.enrichers().add(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating((AttributeSensor)Changeable.GROUP_SIZE).publishing(FABRIC_SIZE).fromMembers()).computingSum()).valueToReportIfNoSensors(0)).build());
        this.sensors().set(SERVICE_UP, false);
    }

    protected EntitySpec<?> getFirstMemberSpec() {
        return (EntitySpec)this.getConfig(FIRST_MEMBER_SPEC);
    }

    protected EntitySpec<?> getMemberSpec() {
        return (EntitySpec)this.getConfig(MEMBER_SPEC);
    }

    protected String getDisplayNamePrefix() {
        return (String)this.getConfig(DISPLAY_NAME_PREFIX);
    }

    protected String getDisplayNameSuffix() {
        return (String)this.getConfig(DISPLAY_NAME_SUFFIX);
    }

    @Override
    public void setMemberSpec(EntitySpec<?> memberSpec) {
        this.setConfigEvenIfOwned(MEMBER_SPEC, memberSpec);
    }

    @Override
    public void start(Collection<? extends Location> locsO) {
        boolean includeInitialChildren = Boolean.TRUE.equals(this.config().get(INCLUDE_INITIAL_CHILDREN));
        this.addLocations(locsO);
        Collection<? extends Location> allLocations = Locations.getLocationsCheckingAncestors(locsO, this);
        Preconditions.checkNotNull(allLocations, (Object)"locations must be supplied");
        Preconditions.checkArgument((allLocations.size() >= 1 ? 1 : 0) != 0, (Object)"One or more locations must be supplied");
        ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
        try {
            LinkedHashMap tasks = Maps.newLinkedHashMap();
            List<Location> locationsForMembers = this.startChildren(includeInitialChildren, allLocations, tasks);
            for (Location it : locationsForMembers) {
                Entity e = this.addCluster(it);
                ((EntityInternal)e).addLocations(Arrays.asList(it));
                if (!(e instanceof Startable)) continue;
                Task task = Entities.submit((Entity)this, Effectors.invocation(e, START, ImmutableMap.of((Object)"locations", (Object)ImmutableList.of((Object)it))).asTask());
                tasks.put(e, task);
            }
            this.waitForTasksOnStart(tasks);
            ServiceStateLogic.setExpectedState(this, Lifecycle.RUNNING);
            this.sensors().set(SERVICE_UP, true);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected List<Location> startChildren(boolean includeInitialChildren, Collection<? extends Location> allLocations, Map<Entity, Task<?>> tasks) {
        MutableList locations = MutableList.copyOf(allLocations);
        int locIndex = 0;
        for (Entity child : this.getChildren()) {
            if (!(child instanceof Startable)) continue;
            if (includeInitialChildren) {
                this.addMember(child);
            }
            Location it = null;
            if (child.getLocations().isEmpty() && !locations.isEmpty()) {
                it = includeInitialChildren ? (Location)locations.get(locIndex++ % locations.size()) : (Location)locations.get(0);
                ((EntityInternal)child).addLocations(Arrays.asList(it));
            }
            tasks.put(child, Entities.submit((Entity)this, Effectors.invocation(child, START, ImmutableMap.of((Object)"locations", (Object)(it == null ? ImmutableList.of() : ImmutableList.of((Object)it)))).asTask()));
        }
        while (locIndex-- > 0 && !locations.isEmpty()) {
            locations.remove(0);
        }
        return locations;
    }

    protected void waitForTasksOnStart(Map<Entity, Task<?>> tasks) {
        for (Map.Entry<Entity, Task<?>> entry : tasks.entrySet()) {
            try {
                entry.getValue().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            catch (ExecutionException ee) {
                throw Throwables.propagate((Throwable)ee.getCause());
            }
        }
    }

    @Override
    public void stop() {
        ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPING);
        try {
            Iterable stoppableChildren = Iterables.filter(this.getChildren(), (Predicate)Predicates.instanceOf(Startable.class));
            Task<?> invoke = Entities.invokeEffector((Entity)this, stoppableChildren, Startable.STOP);
            if (invoke != null) {
                invoke.get();
            }
            ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPED);
            this.sensors().set(SERVICE_UP, false);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void restart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getFabricSize() {
        int result = 0;
        for (Entity child : this.getChildren()) {
            result += ((Integer)JavaGroovyEquivalents.elvis((Object)child.getAttribute(Changeable.GROUP_SIZE), (Object)0)).intValue();
        }
        return result;
    }

    @Override
    public boolean removeChild(Entity child) {
        boolean changed = super.removeChild(child);
        if (changed) {
            this.removeMember(child);
        }
        return changed;
    }

    protected Map getCustomChildFlags() {
        Map result = (Map)this.getConfig(CUSTOM_CHILD_FLAGS);
        return result == null ? ImmutableMap.of() : result;
    }

    protected Entity addCluster(Location location) {
        String locationName = (String)JavaGroovyEquivalents.elvis((Object[])new Object[]{location.getDisplayName(), location.getDisplayName(), null});
        LinkedHashMap creation = Maps.newLinkedHashMap();
        creation.putAll(this.getCustomChildFlags());
        if (JavaGroovyEquivalents.groovyTruth((String)this.getDisplayNamePrefix()) || JavaGroovyEquivalents.groovyTruth((String)this.getDisplayNameSuffix())) {
            String displayName = "" + JavaGroovyEquivalents.elvis((String)this.getDisplayNamePrefix(), (String)"") + JavaGroovyEquivalents.elvis((String)locationName, (String)"unnamed") + JavaGroovyEquivalents.elvis((String)this.getDisplayNameSuffix(), (String)"");
            creation.put("displayName", displayName);
        }
        logger.info("Creating entity in fabric {} at {}{}", new Object[]{this, location, creation != null && !creation.isEmpty() ? ", properties " + creation : ""});
        Entity entity = this.createCluster(location, creation);
        if (locationName != null) {
            if (entity.getDisplayName() == null) {
                entity.setDisplayName(entity.getEntityType().getSimpleName() + " (" + locationName + ")");
            } else if (!entity.getDisplayName().contains(locationName)) {
                entity.setDisplayName(entity.getDisplayName() + " (" + locationName + ")");
            }
        }
        if (entity.getParent() == null) {
            entity.setParent((Entity)this);
        }
        Entities.manage(entity);
        this.addMember(entity);
        return entity;
    }

    protected Entity createCluster(Location location, Map flags) {
        EntitySpec<?> memberSpec = null;
        if (this.getMembers().isEmpty()) {
            memberSpec = this.getFirstMemberSpec();
        }
        if (memberSpec == null) {
            memberSpec = this.getMemberSpec();
        }
        if (memberSpec == null) {
            throw new IllegalStateException("No member spec nor entity factory supplied for dynamic fabric " + this);
        }
        EntitySpec specConfigured = (EntitySpec)EntitySpec.create(memberSpec).configure(flags);
        if (location != null) {
            specConfigured.location(location);
        }
        return this.addChild(specConfigured);
    }
}

