/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.CollectionMerger;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.QuotedStringTokenizer;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformMerge
extends WorkflowTransformDefault {
    private static final Logger log = LoggerFactory.getLogger(TransformMerge.class);
    boolean deep;
    boolean wait;
    boolean lax;
    boolean map;
    boolean list;
    boolean set;

    @Override
    protected void initCheckingDefinition() {
        MutableSet d = MutableSet.copyOf(this.definition.subList(1, this.definition.size()));
        this.deep = d.remove("deep");
        this.wait = d.remove("wait");
        this.lax = d.remove("lax");
        this.map = d.remove("map");
        this.list = d.remove("list");
        this.set = d.remove("set");
        if (this.map && this.list) {
            throw new IllegalArgumentException("Invalid arguments to merge; cannot specify map and list");
        }
        if (this.map && this.set) {
            throw new IllegalArgumentException("Invalid arguments to merge; cannot specify map and set");
        }
        if (this.list && this.set) {
            throw new IllegalArgumentException("Invalid arguments to merge; cannot specify list and set");
        }
        if (!d.isEmpty()) {
            throw new IllegalArgumentException("Unsupported merge arguments: " + d);
        }
    }

    @Override
    public Boolean resolvedValueRequirement() {
        return false;
    }

    @Override
    public Boolean resolvedValueReturned() {
        return true;
    }

    QuotedStringTokenizer qst(String input) {
        return QuotedStringTokenizer.builder().includeQuotes(true).includeDelimiters(true).expectQuotesDelimited(true).failOnOpenQuote(true).build(input);
    }

    public Object apply(Object v) {
        Object result = null;
        if (!(v instanceof Iterable)) {
            if (v instanceof String) {
                v = this.qst((String)v).remainderRaw();
            } else {
                throw new IllegalStateException("Invalid value to merge: " + v);
            }
        }
        if (!(this.map || this.list || this.set)) {
            this.map = Iterables.any((Iterable)((Iterable)v), vi -> vi instanceof Map || vi instanceof String && ((String)vi).startsWith("{"));
            this.list = Iterables.any((Iterable)((Iterable)v), vi -> vi instanceof Iterable || vi instanceof String && ((String)vi).startsWith("["));
        }
        if (this.map && this.list) {
            throw new IllegalStateException("Invalid value to merge; contains combination of list and map");
        }
        Class type = this.map ? Map.class : (this.list ? List.class : (this.set ? Set.class : Object.class));
        Function<Class, Object> resultInit = t -> {
            if (t == Map.class) {
                return MutableMap.of();
            }
            if (t == List.class) {
                return MutableList.of();
            }
            if (t == Set.class) {
                return MutableSet.of();
            }
            throw new IllegalStateException("Unexpected type " + t);
        };
        for (Object vi2 : (Iterable)v) {
            if (vi2 instanceof String && Strings.isBlank((CharSequence)((String)vi2))) continue;
            try {
                vi2 = this.wait ? this.context.resolveWaiting(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, vi2, TypeToken.of(type)) : this.context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, vi2, TypeToken.of(type));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (this.lax) {
                    log.debug("Ignoring entry " + vi2 + " when transforming for merge because cannot be resolved to " + type.getName());
                    continue;
                }
                throw Exceptions.propagate((Throwable)e);
            }
            if (vi2 instanceof Map) {
                type = Map.class;
                if (result == null) {
                    result = resultInit.apply(type);
                }
                if (!(result instanceof Map)) {
                    throw new IllegalArgumentException("Invalid value to merge; contains a map when expected a list");
                }
                if (this.deep) {
                    result = CollectionMerger.builder().build().merge((Map)result, (Map)vi2);
                    continue;
                }
                ((Map)result).putAll((Map)vi2);
                continue;
            }
            if (vi2 instanceof Collection) {
                Class clazz = type = this.set ? Set.class : List.class;
                if (result == null) {
                    result = resultInit.apply(type);
                }
                if (!(result instanceof Collection)) {
                    throw new IllegalArgumentException("Invalid value to merge; contains a map when expected a list or set");
                }
                if (this.deep && !this.lax) {
                    throw new IllegalArgumentException("Invalid value to deep merge; deep only applies to maps and a collection was encountered");
                }
                ((Collection)result).addAll((Collection)vi2);
                continue;
            }
            if (this.lax) continue;
            throw new IllegalArgumentException("Invalid value to merge (specify lax mode to ignore): " + vi2);
        }
        return result;
    }
}

