/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensorInitializer;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.time.Duration;

public class DurationSinceSensor
extends AddSensorInitializer<Duration> {
    private static final Supplier<Long> CURRENT_TIME_SUPPLIER = new CurrentTimeSupplier();
    public static final ConfigKey<Supplier<Long>> EPOCH_SUPPLIER = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Supplier<Long>>(){}).name("duration.since.epochsupplier")).description("The source of time from which durations are measured. Defaults to System.currentTimeMillis when if no supplier is given or the configured supplier returns null.")).defaultValue(CURRENT_TIME_SUPPLIER)).build();
    public static final ConfigKey<Supplier<Long>> TIME_SUPPLIER = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Supplier<Long>>(){}).name("duration.since.timesupplier")).description("The source of the current time. Defaults to System.currentTimeMillis if unconfigured or the supplier returns null.")).defaultValue(CURRENT_TIME_SUPPLIER)).build();

    public DurationSinceSensor() {
    }

    public DurationSinceSensor(ConfigBag params) {
        super(params);
    }

    @Override
    public void apply(EntityLocal entity) {
        AttributeSensor sensor = this.addSensor(entity);
        AttributeSensor<Long> epochSensor = Sensors.newLongSensor(sensor.getName() + ".epoch");
        if (entity.sensors().get(epochSensor) == null) {
            Long epoch = (Long)this.initParam(EPOCH_SUPPLIER).get();
            if (epoch == null) {
                epoch = (Long)CURRENT_TIME_SUPPLIER.get();
            }
            entity.sensors().set(epochSensor, (Object)epoch);
        }
        FunctionFeed.builder().entity((Entity)entity).poll(new FunctionPollConfig(sensor).callable(new UpdateTimeSince(entity, epochSensor, this.initParam(TIME_SUPPLIER)))).period((Duration)this.initParam(SENSOR_PERIOD)).build(true);
    }

    private static class UpdateTimeSince
    implements Callable<Duration> {
        private final Entity entity;
        private final AttributeSensor<Long> epochSensor;
        private final Supplier<Long> timeSupplier;

        private <T> UpdateTimeSince(EntityLocal entity, AttributeSensor<Long> epochSensor, Supplier<Long> timeSupplier) {
            this.entity = entity;
            this.epochSensor = epochSensor;
            this.timeSupplier = timeSupplier;
        }

        @Override
        public Duration call() {
            Long referencePoint = (Long)this.entity.sensors().get(this.epochSensor);
            if (referencePoint != null) {
                Long time = (Long)this.timeSupplier.get();
                if (time == null) {
                    time = (Long)CURRENT_TIME_SUPPLIER.get();
                }
                return Duration.millis((Number)(time - referencePoint));
            }
            throw new IllegalStateException("Cannot calculate duration since sensor: " + this.entity + " missing required value for " + this.epochSensor);
        }
    }

    private static class CurrentTimeSupplier
    implements Supplier<Long> {
        private CurrentTimeSupplier() {
        }

        public Long get() {
            return System.currentTimeMillis();
        }
    }
}

