/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs.proxy;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.proxy.InternalFactory;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalLocationFactory
extends InternalFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InternalLocationFactory.class);

    public InternalLocationFactory(ManagementContextInternal managementContext) {
        super(managementContext);
    }

    public <T extends Location> T createLocation(LocationSpec<T> spec) {
        if (spec.getFlags().containsKey("parent")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent; use spec.parent() instead for " + spec);
        }
        if (spec.getFlags().containsKey("id")) {
            throw new IllegalArgumentException("Spec's flags must not contain id; use spec.id() instead for " + spec);
        }
        try {
            Class clazz = spec.getType();
            Location loc = (Location)this.construct(clazz, (AbstractBrooklynObjectSpec<?, ?>)spec, null);
            if (Locations.isManaged(loc)) {
                LOG.trace("Location-factory returning pre-existing location; skipping initialization of {}", (Object)loc);
                return (T)loc;
            }
            this.managementContext.prePreManage(loc);
            AbstractLocation location = (AbstractLocation)loc;
            if (spec.getDisplayName() != null) {
                location.setDisplayName(spec.getDisplayName());
            }
            if (spec.getCatalogItemId() != null) {
                location.setCatalogItemIdAndSearchPath(spec.getCatalogItemId(), spec.getCatalogItemIdSearchPath());
            } else {
                location.addSearchPath(spec.getCatalogItemIdSearchPath());
            }
            loc.tags().addTags((Iterable)spec.getTags());
            if (InternalLocationFactory.isNewStyle(clazz)) {
                location.setManagementContext(this.managementContext);
                location.configure((Map)ConfigBag.newInstance().putAll(spec.getFlags()).putAll(spec.getConfig()).getAllConfig());
            }
            for (Map.Entry entry : spec.getConfig().entrySet()) {
                location.config().set((ConfigKey)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : spec.getExtensions().entrySet()) {
                ((LocationInternal)loc).addExtension((Class)entry.getKey(), entry.getValue());
            }
            location.init();
            Location parent = spec.getParent();
            if (parent != null) {
                loc.setParent(parent);
            }
            return (T)loc;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Location> T constructLocation(Class<T> clazz) {
        return (T)((Location)super.constructNewStyle(clazz));
    }

    @Override
    protected <T> T constructOldStyle(Class<T> clazz, Map<String, ?> flags) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (flags.containsKey("parent") || flags.containsKey("owner")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent or owner; use spec.parent() instead for " + clazz);
        }
        return super.constructOldStyle(clazz, flags);
    }
}

