/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.classloading;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.classloading.AbstractBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.util.guava.Maybe;

public class OsgiBrooklynClassLoadingContext
extends AbstractBrooklynClassLoadingContext {
    private final String catalogItemId;
    private final boolean hasBundles;
    private transient Collection<? extends OsgiBundleWithUrl> _bundles;

    public OsgiBrooklynClassLoadingContext(ManagementContext mgmt, String catalogItemId, Collection<? extends OsgiBundleWithUrl> bundles) {
        super(mgmt);
        this._bundles = bundles;
        this.hasBundles = bundles != null && !bundles.isEmpty();
        this.catalogItemId = catalogItemId;
    }

    public OsgiBrooklynClassLoadingContext(Entity entity) {
        this(((EntityInternal)entity).getManagementContext(), entity.getCatalogItemId(), null);
    }

    public Collection<? extends OsgiBundleWithUrl> getBundles() {
        if (this.hasBundles) {
            return this._bundles;
        }
        if (this.catalogItemId != null) {
            RegisteredType item = this.mgmt.getTypeRegistry().get(this.catalogItemId);
            if (item == null) {
                throw new IllegalStateException("Catalog item not found for " + this.catalogItemId + "; cannot create loading context");
            }
            this._bundles = item.getLibraries();
            return this._bundles;
        }
        return Collections.emptyList();
    }

    @Override
    public Maybe<Class<?>> tryLoadClass(String className) {
        Maybe clazz = null;
        Maybe<OsgiManager> osgi = null;
        if (this.mgmt != null && (osgi = ((ManagementContextInternal)this.mgmt).getOsgiManager()).isPresent() && this.getBundles() != null && !this.getBundles().isEmpty()) {
            if (!Entitlements.isEntitled(this.mgmt.getEntitlementManager(), Entitlements.SEE_CATALOG_ITEM, this.catalogItemId)) {
                return Maybe.absent((String)"Not entitled to use this catalog entry");
            }
            clazz = ((OsgiManager)osgi.get()).tryResolveClass(className, this.getBundles());
            if (clazz.isPresent()) {
                return clazz;
            }
        }
        if (clazz != null) {
            return clazz;
        }
        if (this.mgmt == null) {
            return Maybe.absent((String)("No mgmt context available for loading " + className));
        }
        if (osgi != null && osgi.isAbsent()) {
            return Maybe.absent((String)("OSGi not available on mgmt for loading " + className));
        }
        if (!this.hasBundles) {
            return Maybe.absent((String)("No bundles available for loading " + className));
        }
        return Maybe.absent((String)("Inconsistent state (" + this.mgmt + "/" + osgi + "/" + this.getBundles() + " loading " + className));
    }

    @Override
    public String toString() {
        return "OSGi:" + this.catalogItemId + "[" + this.getBundles() + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getBundles(), this.catalogItemId});
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OsgiBrooklynClassLoadingContext)) {
            return false;
        }
        OsgiBrooklynClassLoadingContext other = (OsgiBrooklynClassLoadingContext)obj;
        if (!this.catalogItemId.equals(other.catalogItemId)) {
            return false;
        }
        return Objects.equal(this.getBundles(), other.getBundles());
    }

    public URL getResource(String name) {
        Maybe<OsgiManager> osgi;
        if (this.mgmt != null && this.isEntitledToSeeCatalogItem() && (osgi = ((ManagementContextInternal)this.mgmt).getOsgiManager()).isPresent() && this.hasBundles) {
            return ((OsgiManager)osgi.get()).getResource(name, this.getBundles());
        }
        return null;
    }

    public Iterable<URL> getResources(String name) {
        Maybe<OsgiManager> osgi;
        if (this.mgmt != null && this.isEntitledToSeeCatalogItem() && (osgi = ((ManagementContextInternal)this.mgmt).getOsgiManager()).isPresent() && this.hasBundles) {
            return ((OsgiManager)osgi.get()).getResources(name, this.getBundles());
        }
        return Collections.emptyList();
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    private boolean isEntitledToSeeCatalogItem() {
        return Entitlements.isEntitled(this.mgmt.getEntitlementManager(), Entitlements.SEE_CATALOG_ITEM, this.catalogItemId);
    }
}

