/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Runnables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.entity.stock.BasicApplication;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagementUtils {
    private static final Logger log = LoggerFactory.getLogger(EntityManagementUtils.class);
    public static final ConfigKey<Boolean> WRAPPER_APP_MARKER = ((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class, "brooklyn.wrapper_app").runtimeInheritance(BasicConfigInheritance.NEVER_INHERITED)).build();
    static final Set<String> ALLOWABLE_COLLAPSING_KEYS = MutableList.of(WRAPPER_APP_MARKER, BrooklynConfigKeys.TEMPLATE_ID).stream().map(ConfigKey::getName).collect(Collectors.toSet());
    public static final boolean DIFFERENT_NAME_BLOCKS_UNWRAPPING = true;
    public static final boolean DIFFERENT_CONFIG_BLOCKS_UNWRAPPING = true;

    public static <T extends Application> T createUnstarted(ManagementContext mgmt, EntitySpec<T> spec) {
        return EntityManagementUtils.createUnstarted(mgmt, spec, (Optional<String>)Optional.absent());
    }

    @Beta
    public static <T extends Application> T createUnstarted(ManagementContext mgmt, EntitySpec<T> spec, Optional<String> entityId) {
        return (T)((Application)mgmt.getServerExecutionContext().get(Tasks.builder().dynamic(false).displayName("Creating entity " + (Strings.isNonBlank((CharSequence)spec.getDisplayName()) ? spec.getDisplayName() : spec.getType().getName())).body(() -> (Application)((EntityManagerInternal)mgmt.getEntityManager()).createEntity(spec, entityId)).build()));
    }

    public static Application createUnstarted(ManagementContext mgmt, String plan) {
        EntitySpec<? extends Application> spec = EntityManagementUtils.createEntitySpecForApplication(mgmt, plan);
        return EntityManagementUtils.createUnstarted(mgmt, spec);
    }

    public static EntitySpec<? extends Application> createEntitySpecForApplication(ManagementContext mgmt, String plan) {
        return EntityManagementUtils.createEntitySpecForApplication(mgmt, null, plan);
    }

    public static EntitySpec<? extends Application> createEntitySpecForApplication(ManagementContext mgmt, String format, String plan) {
        return (EntitySpec)mgmt.getTypeRegistry().createSpecFromPlan(format, (Object)plan, RegisteredTypeLoadingContexts.spec(Application.class), EntitySpec.class);
    }

    public static <T extends Application> CreationResult<T, Void> createStarting(ManagementContext mgmt, EntitySpec<T> appSpec) {
        return EntityManagementUtils.start(EntityManagementUtils.createUnstarted(mgmt, appSpec));
    }

    public static CreationResult<? extends Application, Void> createStarting(ManagementContext mgmt, String appSpec) {
        return EntityManagementUtils.start(EntityManagementUtils.createUnstarted(mgmt, appSpec));
    }

    public static <T extends Application> CreationResult<T, Void> start(T app) {
        Task<Void> task = Entities.invokeEffector(app, app, Startable.START, MutableMap.of((Object)"locations", (Object)MutableList.of()));
        return CreationResult.of(app, task);
    }

    public static CreationResult<List<Entity>, List<String>> addChildren(Entity parent, String yaml, Boolean start) {
        if (Boolean.FALSE.equals(start)) {
            return CreationResult.of(EntityManagementUtils.addChildrenUnstarted(parent, yaml), null);
        }
        return EntityManagementUtils.addChildrenStarting(parent, yaml);
    }

    public static List<Entity> addChildrenUnstarted(Entity parent, String yaml) {
        log.debug("Creating under " + parent + " from yaml:\n{}", (Object)yaml);
        ManagementContext mgmt = parent.getApplication().getManagementContext();
        List<EntitySpec<?>> specs = EntityManagementUtils.getAddChildrenSpecs(mgmt, yaml);
        MutableList children = MutableList.of();
        for (EntitySpec<?> spec : specs) {
            Entity child = parent.addChild(spec);
            children.add(child);
        }
        return children;
    }

    public static List<EntitySpec<?>> getAddChildrenSpecs(ManagementContext mgmt, String yamlMaybeList) {
        MutableList yamls = MutableList.of();
        Object parse = Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)yamlMaybeList));
        if (parse instanceof List) {
            ((List)parse).forEach(arg_0 -> EntityManagementUtils.lambda$getAddChildrenSpecs$1((List)yamls, arg_0));
        } else {
            yamls.add(yamlMaybeList);
        }
        MutableList result = MutableList.of();
        yamls.forEach(arg_0 -> EntityManagementUtils.lambda$getAddChildrenSpecs$2(mgmt, (List)result, arg_0));
        return result;
    }

    public static CreationResult<List<Entity>, List<String>> addChildrenStarting(Entity parent, String yaml) {
        final List<Entity> children = EntityManagementUtils.addChildrenUnstarted(parent, yaml);
        int size = children.size();
        String childrenCountString = size + " " + (size != 1 ? "children" : "child");
        TaskBuilder<List<String>> taskM = Tasks.builder().displayName("add children").dynamic(true).tag("NON-TRANSIENT").body(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)children, EntityFunctions.id()));
            }
        }).description("Add and start " + childrenCountString);
        TaskBuilder taskS = Tasks.builder().parallel(true).displayName("add (parallel)").description("Start each new entity");
        for (Entity child : children) {
            if (child instanceof Startable) {
                taskS.add((TaskAdaptable<?>)Effectors.invocation(child, Startable.START, ImmutableMap.of((Object)"locations", (Object)ImmutableList.of())));
                continue;
            }
            taskS.add((TaskAdaptable<?>)Tasks.builder().displayName("create").description("Skipping start (not a Startable Entity)").body(Runnables.doNothing()).tag(BrooklynTaskTags.tagForTargetEntity(child)).build());
        }
        taskM.add((TaskAdaptable<?>)taskS.build());
        Task<List<String>> task = Entities.submit(parent, taskM.build());
        return CreationResult.of(children, task);
    }

    public static EntitySpec<? extends Entity> unwrapEntity(EntitySpec<? extends Entity> wrapperApplication) {
        return EntityManagementUtils.unwrapEntity(wrapperApplication, false);
    }

    public static EntitySpec<? extends Entity> unwrapEntity(EntitySpec<? extends Entity> wrapperApplication, boolean allowUnwrappingApplicationsWithoutWrapperAppMarker) {
        if (!EntityManagementUtils.canUnwrapEntity(wrapperApplication, allowUnwrappingApplicationsWithoutWrapperAppMarker)) {
            return wrapperApplication;
        }
        EntitySpec wrappedEntity = (EntitySpec)Iterables.getOnlyElement((Iterable)wrapperApplication.getChildren());
        EntitySpec<? extends Entity> wrapperApplicationTyped = wrapperApplication;
        EntityManagementUtils.mergeWrapperParentSpecToChildEntity(wrapperApplicationTyped, wrappedEntity);
        return wrappedEntity;
    }

    public static EntitySpec<? extends Application> unwrapApplication(EntitySpec<? extends Application> wrapperApplication) {
        if (!EntityManagementUtils.canUnwrapApplication(wrapperApplication)) {
            return wrapperApplication;
        }
        EntitySpec<? extends Entity> wrappedApplication = EntityManagementUtils.unwrapEntity(wrapperApplication);
        return wrappedApplication;
    }

    private static void mergeWrapperParentSpecToChildEntity(EntitySpec<? extends Application> wrapperParent, EntitySpec<?> wrappedChild) {
        String otherCatalogItemId;
        String preferredCatalogItemId;
        if (Strings.isNonEmpty((CharSequence)wrapperParent.getDisplayName())) {
            wrappedChild.displayName(wrapperParent.getDisplayName());
        }
        wrappedChild.locationSpecs((Iterable)wrapperParent.getLocationSpecs());
        wrappedChild.locations((Iterable)wrapperParent.getLocations());
        if (!wrapperParent.getParameters().isEmpty()) {
            wrappedChild.parametersAdd((Iterable)wrapperParent.getParameters());
        }
        Map configWithoutWrapperMarker = Maps.filterKeys((Map)wrapperParent.getConfig(), (Predicate)Predicates.not((Predicate)Predicates.equalTo(WRAPPER_APP_MARKER)));
        wrappedChild.configure(configWithoutWrapperMarker);
        wrappedChild.configure(wrapperParent.getFlags());
        if (wrapperParent.getCatalogItemId() != null) {
            preferredCatalogItemId = wrapperParent.getCatalogItemId();
            otherCatalogItemId = wrappedChild.getCatalogItemId();
            if (Objects.equals(otherCatalogItemId, preferredCatalogItemId)) {
                otherCatalogItemId = null;
            }
        } else {
            preferredCatalogItemId = wrappedChild.getCatalogItemId();
            otherCatalogItemId = null;
        }
        MutableList searchPath = MutableList.of().appendAll((Iterable)wrapperParent.getCatalogItemIdSearchPath()).appendIfNotNull((Object)otherCatalogItemId).appendAll((Iterable)wrappedChild.getCatalogItemIdSearchPath());
        wrappedChild.catalogItemIdAndSearchPath(preferredCatalogItemId, (Collection)searchPath);
        wrappedChild.tagsReplace((Iterable)MutableList.copyOf((Iterable)wrapperParent.getTags()).appendAll((Iterable)wrappedChild.getTags()));
    }

    public static EntitySpec<? extends Application> newWrapperApp() {
        return (EntitySpec)EntitySpec.create(BasicApplication.class).configure(WRAPPER_APP_MARKER, (Object)true);
    }

    public static boolean canUnwrapApplication(EntitySpec<? extends Application> wrapperApplication) {
        if (!EntityManagementUtils.canUnwrapEntity(wrapperApplication)) {
            return false;
        }
        EntitySpec childSpec = (EntitySpec)Iterables.getOnlyElement((Iterable)wrapperApplication.getChildren());
        return childSpec.getType() != null && Application.class.isAssignableFrom(childSpec.getType());
    }

    public static boolean canUnwrapEntity(EntitySpec<? extends Entity> spec) {
        return EntityManagementUtils.canUnwrapEntity(spec, false);
    }

    public static boolean canUnwrapEntity(EntitySpec<? extends Entity> spec, boolean allowUnwrappingApplicationsWithoutWrapperAppMarker) {
        return (allowUnwrappingApplicationsWithoutWrapperAppMarker && Application.class.isAssignableFrom(spec.getType()) || EntityManagementUtils.isWrapperApp(spec)) && EntityManagementUtils.hasMergeableSingleChild(spec);
    }

    private static boolean hasMergeableSingleChild(EntitySpec<? extends Entity> spec) {
        Object v;
        String kn;
        if (!EntityManagementUtils.hasSingleChild(spec)) {
            return false;
        }
        EntitySpec child = (EntitySpec)Iterables.getOnlyElement((Iterable)spec.getChildren());
        if (!EntityManagementUtils.allParentSubsetOfChild(spec, (EntitySpec<? extends Entity>)child, EntitySpec::getEnricherSpecs, EntitySpec::getInitializers, EntitySpec::getPolicySpecs)) {
            return false;
        }
        if (Strings.isNonBlank((CharSequence)spec.getDisplayName()) && Strings.isNonBlank((CharSequence)child.getDisplayName()) && !spec.getDisplayName().equals(child.getDisplayName())) {
            return false;
        }
        MutableMap configAndFlagValues = MutableMap.of();
        for (Map.Entry entry : spec.getFlags().entrySet()) {
            kn = (String)entry.getKey();
            if (ALLOWABLE_COLLAPSING_KEYS.contains(kn)) continue;
            configAndFlagValues.put(kn, entry.getValue());
        }
        for (Map.Entry entry : spec.getConfig().entrySet()) {
            kn = ((ConfigKey)entry.getKey()).getName();
            if (ALLOWABLE_COLLAPSING_KEYS.contains(kn)) continue;
            configAndFlagValues.put(kn, entry.getValue());
        }
        for (Map.Entry entry : child.getFlags().entrySet()) {
            kn = (String)entry.getKey();
            v = configAndFlagValues.get(kn);
            if (v == null || v.equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : child.getConfig().entrySet()) {
            kn = ((ConfigKey)entry.getKey()).getName();
            v = configAndFlagValues.get(kn);
            if (v == null || v.equals(entry.getValue())) continue;
            return false;
        }
        if (!(spec.getLocations().isEmpty() && spec.getLocationSpecs().isEmpty() || ((EntitySpec)Iterables.getOnlyElement((Iterable)spec.getChildren())).getLocations().isEmpty() && child.getLocationSpecs().isEmpty())) {
            return false;
        }
        Set parentParamsWithDefaults = spec.getParameters().stream().filter(p -> p.getConfigKey().getDefaultValue() != null).map(p -> p.getConfigKey().getName()).collect(Collectors.toSet());
        return !child.getConfig().keySet().stream().anyMatch(k -> parentParamsWithDefaults.contains(k.getName()));
    }

    private static boolean allParentSubsetOfChild(EntitySpec<? extends Entity> spec, EntitySpec<? extends Entity> child, Function<EntitySpec<? extends Entity>, Collection<?>> ... getters) {
        for (Function<EntitySpec<Entity>, Collection<?>> function : getters) {
            if (MutableSet.copyOf((Iterable)function.apply(child)).containsAll(function.apply(spec))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWrapperApp(EntitySpec<?> spec) {
        return Boolean.TRUE.equals(spec.getConfig().get(WRAPPER_APP_MARKER));
    }

    private static boolean hasSingleChild(EntitySpec<?> spec) {
        return spec.getChildren().size() == 1;
    }

    private static /* synthetic */ void lambda$getAddChildrenSpecs$2(ManagementContext mgmt, List result, String yaml) {
        int size;
        EntitySpec spec;
        block7: {
            spec = null;
            try {
                spec = (EntitySpec)mgmt.getTypeRegistry().createSpecFromPlan(null, (Object)yaml, null, EntitySpec.class);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                try {
                    Object yo = Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)yaml));
                    spec = (EntitySpec)TypeCoercions.tryCoerce(yo, EntitySpec.class).orNull();
                    if (spec.getType() == null && spec.getImplementation() == null) {
                        if (log.isTraceEnabled()) {
                            log.trace("Failed converting entity spec YAML as YAML, transformer error will throw, but also created a bogus empty spec: " + spec + ", from " + yo);
                        }
                        spec = null;
                    }
                }
                catch (Exception e2) {
                    log.debug("Failed converting entity spec YAML as YAML, transformer error will throw, but also encountered: " + e2);
                }
                if (spec != null) break block7;
                throw Exceptions.propagate((Throwable)e);
            }
        }
        if (!EntityManagementUtils.canUnwrapEntity((EntitySpec<? extends Entity>)spec) && Strings.isEmpty((CharSequence)spec.getDisplayName()) && (size = spec.getChildren().size()) > 0) {
            String childrenCountString = size == 1 ? "child" : size + " children";
            spec.displayName("Dynamically added " + childrenCountString);
        }
        result.add(spec);
    }

    private static /* synthetic */ void lambda$getAddChildrenSpecs$1(List yamls, Object li) {
        try {
            yamls.add(BeanWithTypeUtils.newYamlMapper(null, false, null, false).writeValueAsString(li));
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)"Invalid YAML for adding child", (Throwable)e);
        }
    }

    public static class CreationResult<T, U> {
        private final T thing;
        @Nullable
        private final Task<U> task;

        public CreationResult(T thing, Task<U> task) {
            this.thing = thing;
            this.task = task;
        }

        protected static <T, U> CreationResult<T, U> of(T thing, @Nullable Task<U> task) {
            return new CreationResult<T, U>(thing, task);
        }

        @Nullable
        public T get() {
            return this.thing;
        }

        public Task<U> task() {
            return this.task;
        }

        public CreationResult<T, U> blockUntilComplete(Duration timeout) {
            if (this.task != null) {
                this.task.blockUntilEnded(timeout);
            }
            return this;
        }

        public CreationResult<T, U> blockUntilComplete() {
            if (this.task != null) {
                this.task.blockUntilEnded();
            }
            return this;
        }
    }
}

