/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.geo;

import com.google.common.base.Throwables;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.util.XmlParser;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.core.location.geo.HostGeoInfo;
import org.apache.brooklyn.core.location.geo.HostGeoLookup;
import org.apache.brooklyn.core.location.geo.LocalhostExternalIpLoader;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Durations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtraceHostGeoLookup
implements HostGeoLookup {
    private static final Duration RETRY_INTERVAL = Duration.FIVE_MINUTES;
    private static final Duration REQUEST_TIMEOUT = Duration.seconds((Number)3);
    public static final Logger log = LoggerFactory.getLogger(UtraceHostGeoLookup.class);
    private static boolean LOGGED_GEO_LOOKUP_UNAVAILABLE = false;
    private static long LAST_FAILURE_UTC = -1L;
    private static boolean loggedInternetIssues = false;

    public String getLookupUrlForPublicIp(String ip) {
        return "http://xml.utrace.de/?query=" + ip.trim();
    }

    public String getLookupUrlForLocalhost() {
        return this.getLookupUrlForPublicIp(LocalhostExternalIpLoader.getLocalhostIpQuicklyOrDefault());
    }

    public String getLookupUrlFor(InetAddress address) {
        if (Networking.isPrivateSubnet((InetAddress)address)) {
            return this.getLookupUrlForLocalhost();
        }
        return this.getLookupUrlForPublicIp(address.getHostAddress());
    }

    @Override
    public HostGeoInfo getHostGeoInfo(InetAddress address) throws MalformedURLException, IOException {
        if (this.isHostGeoLookupGloballyDisabled()) {
            return null;
        }
        if (Duration.sinceUtc((long)LAST_FAILURE_UTC).compareTo(RETRY_INTERVAL) < 0) {
            return null;
        }
        return this.getHostGeoInfo(address, REQUEST_TIMEOUT);
    }

    public HostGeoInfo getHostGeoInfo(final InetAddress address, Duration timeout) throws MalformedURLException, IOException {
        final AtomicReference result = new AtomicReference();
        Thread lt = new Thread(){

            @Override
            public void run() {
                try {
                    result.set(UtraceHostGeoLookup.this.retrieveHostGeoInfo(address));
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (loggedInternetIssues) {
                        log.debug("Error computing geo info for " + address + "; internet issues or too many requests to (free) servers for " + JavaClassNames.simpleClassName((Object)UtraceHostGeoLookup.this) + " (see previous WARN message for detail): " + e);
                    }
                    loggedInternetIssues = true;
                    log.warn("Error computing geo info for " + address + "; internet issues or too many requests to (free) servers for " + JavaClassNames.simpleClassName((Object)UtraceHostGeoLookup.this) + " (subsequent errors at debug): " + e);
                    log.debug("Detail of host geo error: " + e, (Throwable)e);
                }
            }
        };
        lt.start();
        try {
            Durations.join((Thread)lt, (Duration)timeout);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (lt.isAlive()) {
            lt.interrupt();
            LAST_FAILURE_UTC = System.currentTimeMillis();
            log.debug("Geo info lookup for " + address + " timed out after " + timeout);
        }
        return (HostGeoInfo)result.get();
    }

    public HostGeoInfo retrieveHostGeoInfo(InetAddress address) throws MalformedURLException, IOException {
        Node xml;
        String url = this.getLookupUrlFor(address);
        if (log.isDebugEnabled()) {
            log.debug("Geo info lookup for " + address + " at " + url);
        }
        try {
            xml = new XmlParser().parse(this.getLookupUrlFor(address));
        }
        catch (Exception e) {
            LAST_FAILURE_UTC = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Geo info lookup for " + address + " failed: " + e);
            }
            if (!LOGGED_GEO_LOOKUP_UNAVAILABLE) {
                LOGGED_GEO_LOOKUP_UNAVAILABLE = true;
                log.info("Geo info lookup unavailable (for " + address + "; cause " + e + ")");
            }
            return null;
        }
        try {
            String org = UtraceHostGeoLookup.getXmlResultsField(xml, "org").trim();
            if (org.isEmpty()) {
                org = UtraceHostGeoLookup.getXmlResultsField(xml, "isp").trim();
            }
            String region = UtraceHostGeoLookup.getXmlResultsField(xml, "region").trim();
            if (!org.isEmpty()) {
                region = !region.isEmpty() ? org + ", " + region : org;
            }
            if (region.isEmpty()) {
                region = UtraceHostGeoLookup.getXmlResultsField(xml, "isp").trim();
            }
            if (region.isEmpty()) {
                region = address.toString();
            }
            HostGeoInfo geo = new HostGeoInfo(address.getHostName(), region + " (" + UtraceHostGeoLookup.getXmlResultsField(xml, "countrycode") + ")", Double.parseDouble("" + UtraceHostGeoLookup.getXmlResultsField(xml, "latitude")), Double.parseDouble("" + UtraceHostGeoLookup.getXmlResultsField(xml, "longitude")));
            log.info("Geo info lookup for " + address + " returned: " + geo);
            return geo;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Geo info lookup failed, for " + address + " at " + url + ", due to " + e + "; response is " + xml);
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Nullable
    private static Node getFirstChild(Node xml, String field) {
        if (xml == null) {
            return null;
        }
        NodeList nl = (NodeList)xml.get(field);
        if (nl == null || nl.isEmpty()) {
            return null;
        }
        return (Node)nl.get(0);
    }

    @Nonnull
    private static String getXmlResultsField(Node xml, String field) {
        Node f1 = UtraceHostGeoLookup.getFirstChild(UtraceHostGeoLookup.getFirstChild(xml, "result"), field);
        if (f1 == null) {
            return "";
        }
        return f1.text();
    }
}

