/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.monitoring.monit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.entity.monitoring.monit.MonitDriver;
import org.apache.brooklyn.entity.monitoring.monit.MonitNode;
import org.apache.brooklyn.entity.monitoring.monit.MonitNodeImpl;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.NaiveScriptRunner;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.ssh.BashCommands;

public class MonitSshDriver
extends AbstractSoftwareProcessSshDriver
implements MonitDriver {
    private String remoteControlFilePath;

    public MonitSshDriver(MonitNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().add((Object)BashCommands.INSTALL_TAR).add((Object)BashCommands.INSTALL_CURL).add((Object)BashCommands.commandToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)String.format("tar xfvz %s", saveAs)).build();
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append((Collection)commands).execute();
    }

    public void customize() {
        this.newScript((String)"customizing").body.append((CharSequence)"echo copying control file").execute();
        String controlFileUrl = (String)this.getEntity().getConfig(MonitNode.CONTROL_FILE_URL);
        this.remoteControlFilePath = this.getRunDir() + "/monit.monitrc";
        this.copyTemplate(controlFileUrl, this.remoteControlFilePath, false, (Map)this.getEntity().getConfig(MonitNode.CONTROL_FILE_SUBSTITUTIONS));
        this.newScript((String)"customizing").body.append((CharSequence)("chmod 600 " + this.remoteControlFilePath)).execute();
    }

    public void launch() {
        String command = String.format("touch %s && nohup %s/bin/monit -c %s -p %s > out.log 2> err.log < /dev/null &", this.getMonitPidFile(), this.getExpandedInstallDir(), this.remoteControlFilePath, this.getMonitPidFile());
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)command).execute();
    }

    public boolean isRunning() {
        ImmutableMap flags = ImmutableMap.of((Object)"usePidFile", (Object)this.getMonitPidFile());
        return this.newScript((Map)flags, "check-running").execute() == 0;
    }

    public void stop() {
        new ScriptHelper((NaiveScriptRunner)this, (String)"Send SIGTERM to Monit process").body.append((CharSequence)("kill -s SIGTERM `cat " + this.getMonitPidFile() + "`")).execute();
    }

    protected String getMonitPidFile() {
        return this.getRunDir() + "/" + "pid.txt";
    }

    public String getMonitLogFile() {
        return this.getRunDir() + "/monit.log";
    }

    public String getOsTag() {
        OsDetails os = this.getLocation().getOsDetails();
        if (os == null) {
            return "linux-x64";
        }
        if (os.isMac()) {
            return "macosx-universal";
        }
        String arch = os.is64bit() ? "x64" : "x86";
        return "linux-" + arch;
    }

    @Override
    public String getStatusCmd() {
        return String.format("%s/bin/monit -c %s status", this.getExpandedInstallDir(), this.remoteControlFilePath);
    }
}

