/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.tomcat;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.webapp.tomcat.Tomcat9ServerImpl;
import org.apache.brooklyn.entity.webapp.tomcat.TomcatServer;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.javalang.JavaClassNames;

@Catalog(name="Tomcat 9 Server", description="Apache Tomcat is an open source software implementation of the Java Servlet and JavaServer Pages technologies", iconUrl="classpath:///tomcat9-logo.png")
@ImplementedBy(value=Tomcat9ServerImpl.class)
public interface Tomcat9Server
extends TomcatServer {
    public static final String TOMCAT9_DOWNLOAD_URL = "https://archive.apache.org/dist/tomcat/tomcat-9/v${version}/bin/apache-tomcat-${version}.tar.gz";
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"9.0.52");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"apache-tomcat-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"https://archive.apache.org/dist/tomcat/tomcat-9/v${version}/bin/apache-tomcat-${version}.tar.gz");
    @SetFromFlag(value="server.xml")
    public static final ConfigKey<String> SERVER_XML_RESOURCE = ConfigKeys.newStringConfigKey((String)"tomcat.serverxml", (String)"The file to template and use as the Tomcat's server.xml", (String)JavaClassNames.resolveClasspathUrl(Tomcat9Server.class, (String)"tomcat9-server.xml"));
    @SetFromFlag(value="web.xml")
    public static final ConfigKey<String> WEB_XML_RESOURCE = ConfigKeys.newStringConfigKey((String)"tomcat.webxml", (String)"The file to template and use as the Tomcat's web.xml", (String)JavaClassNames.resolveClasspathUrl(Tomcat9Server.class, (String)"tomcat9-web.xml"));
}

