/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl.parse;

import java.util.List;
import java.util.function.Supplier;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslInterpreter;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.BrooklynDslCommon;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.DslParser;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.PropertyAccess;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.MutableList;

public class WorkflowTransformGet
extends WorkflowTransformDefault {
    String modifier;

    protected void initCheckingDefinition() {
        MutableList d = MutableList.copyOf(this.definition.subList(1, this.definition.size()));
        if (d.size() > 1) {
            throw new IllegalArgumentException("Transform requires at most a single argument being the index or modifier to get");
        }
        if (!d.isEmpty()) {
            this.modifier = (String)d.get(0);
        }
    }

    public Object apply(Object v) {
        String modifierResolved = (String)this.context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, (Object)this.modifier, String.class);
        if (modifierResolved == null) {
            if (v instanceof Supplier) {
                return ((Supplier)v).get();
            }
            return v;
        }
        if (!(modifierResolved = modifierResolved.trim()).startsWith("[") && !modifierResolved.startsWith(".")) {
            if (modifierResolved.contains(".") || modifierResolved.contains("[") || modifierResolved.contains(" ")) {
                throw new IllegalArgumentException("Argument to 'get' must be a simple key (no spaces, dots, or brackets) or a bracketed string expression or start with an initial dot");
            }
            modifierResolved = "[\"" + modifierResolved + "\"]";
        }
        String m = "$brooklyn:literal(\"ignored\")" + modifierResolved;
        List parse = (List)new DslParser(m).parse();
        parse = parse.subList(1, parse.size());
        BrooklynDslInterpreter ip = new BrooklynDslInterpreter();
        Object result = new BrooklynDslCommon.DslLiteral(v);
        for (Object p : parse) {
            if (p instanceof PropertyAccess) {
                result = ip.evaluateOn(result, (PropertyAccess)p);
                continue;
            }
            throw new IllegalArgumentException("Invalid entry in 'get' transform argument; should be property access/modifiers");
        }
        return ((BrooklynDslDeferredSupplier)result).get();
    }
}

