/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.module.registry.command;

import org.apache.brooklyn.ui.modularity.module.api.UiModule;
import org.apache.brooklyn.ui.modularity.module.api.UiModuleRegistry;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="brooklyn", name="list-ui-modules", description="List registered Brooklyn UI Modules")
@Service
public class ListUiModulesCommand
implements Action {
    @Reference
    private UiModuleRegistry registry;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("ID");
        table.column("NAME");
        table.column("TYPES");
        table.column("PATH");
        for (UiModule component : this.registry.getRegisteredModules()) {
            table.addRow().addContent(new Object[]{component.getId(), component.getName(), component.getTypes(), component.getPath()});
        }
        table.print(System.out, true);
        return null;
    }
}

