/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.util.storageurl;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azure.storage.util.storageurl.StorageUrlSupplier;
import org.jclouds.azure.storage.util.storageurl.TrailingSlashUtil;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;

@Singleton
public class AppendAccountToEndpoint
implements StorageUrlSupplier {
    private final Supplier<URI> endpointSupplier;
    private final Supplier<Credentials> credentialsSupplier;

    @Inject
    public AppendAccountToEndpoint(@Provider Supplier<URI> endpointSupplier, @Provider Supplier<Credentials> credentialsSupplier) {
        this.endpointSupplier = endpointSupplier;
        this.credentialsSupplier = credentialsSupplier;
    }

    public URI get() {
        URI endpoint = (URI)this.endpointSupplier.get();
        Preconditions.checkNotNull((Object)endpoint, (Object)"An endpoint must be configured in order to use AppendAccountToEndpoint module");
        String endpointTrailingSlash = TrailingSlashUtil.ensureTrailingSlash(endpoint) + ((Credentials)this.credentialsSupplier.get()).identity + "/";
        return URI.create(endpointTrailingSlash);
    }
}

