/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.stream;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.brooklyn.util.stream.DelegatingPrintStream;
import org.apache.commons.io.output.TeeOutputStream;

public class ThreadLocalPrintStream
extends DelegatingPrintStream {
    protected PrintStream defaultPrintStream;
    protected final ThreadLocal<PrintStream> customStream = new ThreadLocal();

    public ThreadLocalPrintStream(PrintStream defaultPrintStream) {
        this.defaultPrintStream = defaultPrintStream;
    }

    @Override
    public PrintStream getDelegate() {
        PrintStream delegate = this.customStream.get();
        if (delegate != null) {
            return delegate;
        }
        return this.defaultPrintStream;
    }

    public PrintStream setThreadLocalPrintStream(OutputStream stream) {
        PrintStream old = this.customStream.get();
        if (!(stream instanceof PrintStream)) {
            stream = new PrintStream(stream);
        }
        this.customStream.set((PrintStream)stream);
        return old;
    }

    public PrintStream clearThreadLocalPrintStream() {
        PrintStream old = this.customStream.get();
        this.customStream.remove();
        if (old != null) {
            old.flush();
        }
        return old;
    }

    public OutputCapturingContext capture() {
        return new OutputCapturingContext(this);
    }

    public OutputCapturingContext captureTee() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream toRestore = this.setThreadLocalPrintStream((OutputStream)new TeeOutputStream((OutputStream)this.getDelegate(), (OutputStream)out));
        return new OutputCapturingContext(this, out, toRestore);
    }

    public static synchronized ThreadLocalPrintStream stdout() {
        PrintStream oldOut = System.out;
        if (oldOut instanceof ThreadLocalPrintStream) {
            return (ThreadLocalPrintStream)oldOut;
        }
        ThreadLocalPrintStream newOut = new ThreadLocalPrintStream(System.out);
        System.setOut(newOut);
        return newOut;
    }

    public static synchronized ThreadLocalPrintStream stderr() {
        PrintStream oldErr = System.err;
        if (oldErr instanceof ThreadLocalPrintStream) {
            return (ThreadLocalPrintStream)oldErr;
        }
        ThreadLocalPrintStream newErr = new ThreadLocalPrintStream(System.err);
        System.setErr(newErr);
        return newErr;
    }

    public static class OutputCapturingContext {
        protected final ThreadLocalPrintStream stream;
        protected final ByteArrayOutputStream out;
        protected final OutputStream streamToRestore;
        protected boolean finished = false;

        public OutputCapturingContext(ThreadLocalPrintStream stream) {
            this.stream = stream;
            this.out = new ByteArrayOutputStream();
            this.streamToRestore = stream.setThreadLocalPrintStream(this.out);
        }

        public OutputCapturingContext(ThreadLocalPrintStream stream, ByteArrayOutputStream capturingStream, OutputStream optionalStreamToRestore) {
            this.stream = stream;
            this.out = capturingStream;
            this.streamToRestore = optionalStreamToRestore;
        }

        public String getOutputSoFar() {
            return this.out.toString();
        }

        public String end() {
            if (this.streamToRestore != null) {
                this.stream.setThreadLocalPrintStream(this.streamToRestore);
            } else {
                this.stream.clearThreadLocalPrintStream();
            }
            this.finished = true;
            return this.out.toString();
        }

        public boolean isActive() {
            return !this.finished;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.out;
        }

        public String toString() {
            return this.getOutputSoFar();
        }

        public boolean isEmpty() {
            return this.out.size() == 0;
        }
    }
}

