/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.http.HttpTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAsserts {
    private static final Logger LOG = LoggerFactory.getLogger(HttpAsserts.class);

    public static boolean isHealthyStatusCode(int code) {
        return code >= 200 && code <= 299;
    }

    public static void assertHealthyStatusCode(int code) {
        if (HttpAsserts.isHealthyStatusCode(code)) {
            return;
        }
        Asserts.fail("Expected success status code, got: " + code);
    }

    public static void assertNotHealthyStatusCode(int code) {
        if (!HttpAsserts.isHealthyStatusCode(code)) {
            return;
        }
        Asserts.fail("Expected non-success status code, got: " + code);
    }

    public static boolean isClientErrorStatusCode(int code) {
        return code >= 400 && code <= 499;
    }

    public static void assertClientErrorStatusCode(int code) {
        if (HttpAsserts.isClientErrorStatusCode(code)) {
            return;
        }
        Asserts.fail("Expected client error status code, got: " + code);
    }

    public static boolean isServerErrorStatusCode(int code) {
        return code >= 500 && code <= 599;
    }

    public static void assertServerErrorStatusCode(int code) {
        if (HttpAsserts.isServerErrorStatusCode(code)) {
            return;
        }
        Asserts.fail("Expected server error status code, got: " + code);
    }

    public static void assertUrlReachable(String url) {
        try {
            HttpTool.getHttpStatusCodeUnsafe(url);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted for " + url + " (in assertion that is reachable)", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Server at " + url + " Asserts.failed to respond (in assertion that is reachable): " + e, e);
        }
    }

    public static void assertUrlUnreachable(String url) {
        block3: {
            try {
                int statusCode = HttpTool.getHttpStatusCodeUnsafe(url);
                Asserts.fail("Expected url " + url + " unreachable, but got status code " + statusCode);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted for " + url + " (in assertion that unreachable)", e);
            }
            catch (Exception e) {
                IOException cause = Exceptions.getFirstThrowableOfType(e, IOException.class);
                if (cause != null) break block3;
                HttpAsserts.propagateAsAssertionError(e);
            }
        }
    }

    public static void assertUrlUnreachableEventually(String url) {
        HttpAsserts.assertUrlUnreachableEventually(Maps.newLinkedHashMap(), url);
    }

    public static void assertUrlUnreachableEventually(Map<String, ?> flags, final String url) {
        HttpAsserts.assertEventually(flags, new Runnable(){

            @Override
            public void run() {
                HttpAsserts.assertUrlUnreachable(url);
            }
        });
    }

    public static void assertHttpStatusCodeEquals(String url, int ... acceptableReturnCodes) {
        ArrayList acceptableCodes = Lists.newArrayList();
        for (int code : acceptableReturnCodes) {
            acceptableCodes.add(code);
        }
        try {
            int actualCode = HttpTool.getHttpStatusCodeUnsafe(url);
            Asserts.assertTrue(acceptableCodes.contains(actualCode), "code=" + actualCode + "; expected=" + acceptableCodes + "; url=" + url);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted for " + url + " (in assertion that result code is " + acceptableCodes + ")", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Server at " + url + " Asserts.failed to respond (in assertion that result code is " + acceptableCodes + "): " + e, e);
        }
    }

    public static void assertHttpStatusCodeEventuallyEquals(String url, int expectedCode) {
        HttpAsserts.assertHttpStatusCodeEventuallyEquals(Maps.newLinkedHashMap(), url, expectedCode);
    }

    public static void assertHttpStatusCodeEventuallyEquals(Map<String, ?> flags, final String url, final int expectedCode) {
        HttpAsserts.assertEventually(flags, new Runnable(){

            @Override
            public void run() {
                HttpAsserts.assertHttpStatusCodeEquals(url, expectedCode);
            }
        });
    }

    public static void assertContentContainsText(String url, String phrase, String ... additionalPhrases) {
        try {
            String contents = HttpTool.getContentUnsafe(url);
            Asserts.assertTrue(contents != null && contents.length() > 0);
            for (String text : Lists.asList((Object)phrase, (Object[])additionalPhrases)) {
                if (contents.contains(text)) continue;
                LOG.warn("CONTENTS OF URL " + url + " MISSING TEXT: " + text + "\n" + contents);
                Asserts.fail("URL " + url + " does not contain text: " + text);
            }
        }
        catch (Exception e) {
            throw HttpAsserts.propagateAsAssertionError(e);
        }
    }

    public static void assertContentNotContainsText(String url, String phrase, String ... additionalPhrases) {
        try {
            String contents = HttpTool.getContentUnsafe(url);
            Asserts.assertTrue(contents != null);
            for (String text : Lists.asList((Object)phrase, (Object[])additionalPhrases)) {
                if (!contents.contains(text)) continue;
                LOG.warn("CONTENTS OF URL " + url + " HAS TEXT: " + text + "\n" + contents);
                Asserts.fail("URL " + url + " contain text: " + text);
            }
        }
        catch (Exception e) {
            throw HttpAsserts.propagateAsAssertionError(e);
        }
    }

    public static void assertErrorContentContainsText(String url, String phrase, String ... additionalPhrases) {
        try {
            String contents = HttpTool.getErrorContentUnsafe(url);
            Asserts.assertTrue(contents != null && contents.length() > 0);
            for (String text : Lists.asList((Object)phrase, (Object[])additionalPhrases)) {
                if (contents.contains(text)) continue;
                LOG.warn("CONTENTS OF URL " + url + " MISSING TEXT: " + text + "\n" + contents);
                Asserts.fail("URL " + url + " does not contain text: " + text);
            }
        }
        catch (Exception e) {
            throw HttpAsserts.propagateAsAssertionError(e);
        }
    }

    public static void assertErrorContentNotContainsText(String url, String phrase, String ... additionalPhrases) {
        try {
            String err = HttpTool.getErrorContentUnsafe(url);
            Asserts.assertTrue(err != null);
            for (String text : Lists.asList((Object)phrase, (Object[])additionalPhrases)) {
                if (!err.contains(text)) continue;
                LOG.warn("CONTENTS OF URL " + url + " HAS TEXT: " + text + "\n" + err);
                Asserts.fail("URL " + url + " contain text: " + text);
            }
        }
        catch (Exception e) {
            throw HttpAsserts.propagateAsAssertionError(e);
        }
    }

    private static AssertionError propagateAsAssertionError(Exception e) {
        AssertionError assertionError = new AssertionError("Assertion failed", e);
        return assertionError;
    }

    public static void assertContentEventuallyContainsText(String url, String phrase, String ... additionalPhrases) {
        HttpAsserts.assertContentEventuallyContainsText(MutableMap.of(), url, phrase, additionalPhrases);
    }

    public static void assertContentEventuallyContainsText(Map<String, ?> flags, final String url, final String phrase, final String ... additionalPhrases) {
        HttpAsserts.assertEventually(flags, new Runnable(){

            @Override
            public void run() {
                HttpAsserts.assertContentContainsText(url, phrase, additionalPhrases);
            }
        });
    }

    private static void assertEventually(Map<String, ?> flags, Runnable r) {
        try {
            Asserts.succeedsEventually(flags, r);
        }
        catch (Exception e) {
            throw HttpAsserts.propagateAsAssertionError(e);
        }
    }

    private static void assertEventually(Runnable r) {
        try {
            Asserts.succeedsEventually(r);
        }
        catch (Exception e) {
            throw HttpAsserts.propagateAsAssertionError(e);
        }
    }

    public static void assertContentMatches(String url, String regex) {
        String contents = HttpTool.getContentUnsafe(url);
        Asserts.assertNotNull(contents);
        Asserts.assertTrue(contents.matches(regex), "Contents does not match expected regex (" + regex + "): " + contents);
    }

    public static void assertContentEventuallyMatches(final String url, final String regex) {
        HttpAsserts.assertEventually(new Runnable(){

            @Override
            public void run() {
                HttpAsserts.assertContentMatches(url, regex);
            }
        });
    }

    public static void assertContentEventuallyMatches(Map<String, ?> flags, final String url, final String regex) {
        HttpAsserts.assertEventually(flags, new Runnable(){

            @Override
            public void run() {
                HttpAsserts.assertContentMatches(url, regex);
            }
        });
    }

    public static ListenableFuture<?> assertAsyncHttpStatusCodeContinuallyEquals(ListeningExecutorService executor, final String url, final int expectedStatusCode) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    HttpAsserts.assertHttpStatusCodeEquals(url, expectedStatusCode);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
    }
}

