/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.collections;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.primitives.Primitives;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.text.StringEscapes;

@Beta
public class Jsonya {
    private Jsonya() {
    }

    public static <T extends Map<?, ?>> Navigator<T> of(T map) {
        return new Navigator(map, MutableMap.class);
    }

    public static <T extends Map<?, ?>> Navigator<T> of(Navigator<T> navigator) {
        return new Navigator(navigator.getFocusMap(), MutableMap.class);
    }

    public static Navigator<MutableMap<Object, Object>> newInstance() {
        return new Navigator<MutableMap<Object, Object>>(MutableMap.class);
    }

    public static Navigator<MutableMap<Object, Object>> at(Object ... pathSegments) {
        return Jsonya.newInstance().atArray(pathSegments);
    }

    public static Navigator<MutableMap<Object, Object>> newInstanceTranslating(Function<Object, Object> translator) {
        return Jsonya.newInstance().useTranslator(translator);
    }

    public static Navigator<MutableMap<Object, Object>> newInstanceLiteral() {
        return Jsonya.newInstanceTranslating((Function<Object, Object>)Functions.identity());
    }

    public static Navigator<MutableMap<Object, Object>> newInstancePrimitive() {
        return Jsonya.newInstanceTranslating(new JsonPrimitiveDeepTranslator());
    }

    public static Object convertToJsonPrimitive(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Map) {
            return Jsonya.newInstancePrimitive().put((Map)x).getRootMap();
        }
        return Jsonya.newInstancePrimitive().put("data", x, new Object[0]).getRootMap().get("data");
    }

    public static boolean isJsonPrimitiveCompatible(Object x) {
        if (x == null) {
            return true;
        }
        return Jsonya.convertToJsonPrimitive(x).equals(x);
    }

    public static boolean isTypeJsonPrimitiveCompatible(Object x) {
        if (x == null) {
            return true;
        }
        return x instanceof Map || x instanceof Collection || x instanceof String || Boxing.isPrimitiveOrBoxedObject(x);
    }

    public static boolean isJsonPrimitiveDeep(Object x) {
        if (x == null) {
            return true;
        }
        if (x instanceof String || Boxing.isPrimitiveOrBoxedObject(x)) {
            return true;
        }
        if (x instanceof Map) {
            return !((Map)x).entrySet().stream().anyMatch(ent -> !Jsonya.isJsonPrimitiveDeep(ent.getKey()) || !Jsonya.isJsonPrimitiveDeep(ent.getValue()));
        }
        if (x instanceof Collection) {
            return !((Collection)x).stream().anyMatch(ent -> !Jsonya.isJsonPrimitiveDeep(ent));
        }
        return false;
    }

    public static String render(Object focus) {
        if (focus instanceof Map) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean first = true;
            for (Map.Entry entry : ((Map)focus).entrySet()) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append(" ");
                sb.append(Jsonya.render(entry.getKey()));
                sb.append(": ");
                sb.append(Jsonya.render(entry.getValue()));
            }
            sb.append(" }");
            return sb.toString();
        }
        if (focus instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (Object entry : (Collection)focus) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append(" ");
                sb.append(Jsonya.render(entry));
            }
            sb.append(" ]");
            return sb.toString();
        }
        if (focus instanceof String) {
            return StringEscapes.JavaStringEscapes.wrapJavaString((String)focus);
        }
        if (focus == null || focus instanceof Number || focus instanceof Boolean) {
            return "" + focus;
        }
        return Jsonya.render("" + focus);
    }

    public static class JsonPrimitiveDeepTranslator
    implements Function<Object, Object> {
        public static JsonPrimitiveDeepTranslator INSTANCE = new JsonPrimitiveDeepTranslator();

        protected JsonPrimitiveDeepTranslator() {
        }

        public Object apply(Object input) {
            return this.apply(input, new HashSet<Object>());
        }

        protected Object apply(Object input, Set<Object> stack) {
            if (input == null) {
                return this.applyNull(stack);
            }
            if (JsonPrimitiveDeepTranslator.isPrimitiveOrBoxer(input.getClass())) {
                return this.applyPrimitiveOrBoxer(input, stack);
            }
            if (input instanceof String) {
                return this.applyString((String)input, stack);
            }
            if (!(stack = new HashSet<Object>(stack)).add(input)) {
                return "[REF_ANCESTOR:" + stack.getClass() + "]";
            }
            if (input instanceof Collection) {
                return this.applyCollection((Collection)input, stack);
            }
            if (input instanceof Map) {
                return this.applyMap((Map)input, stack);
            }
            return this.applyOther(input, stack);
        }

        protected Object applyNull(Set<Object> stack) {
            return null;
        }

        protected Object applyPrimitiveOrBoxer(Object input, Set<Object> stack) {
            return input;
        }

        protected Object applyString(String input, Set<Object> stack) {
            return input.toString();
        }

        protected Object applyCollection(Collection<?> input, Set<Object> stack) {
            MutableList result = MutableList.of();
            for (Object xi : input) {
                result.add(this.apply(xi, stack));
            }
            return result;
        }

        protected Object applyMap(Map<?, ?> input, Set<Object> stack) {
            MutableMap<Object, Object> result = MutableMap.of();
            for (Map.Entry<?, ?> xi : input.entrySet()) {
                result.put(this.apply(xi.getKey(), stack), this.apply(xi.getValue(), stack));
            }
            return result;
        }

        protected Object applyOther(Object input, Set<Object> stack) {
            return input.toString();
        }

        public static boolean isPrimitiveOrBoxer(Class<?> type) {
            return Primitives.allPrimitiveTypes().contains(type) || Primitives.allWrapperTypes().contains(type);
        }
    }

    public static class Navigator<T extends Map<?, ?>> {
        protected Object root;
        protected final Class<? extends Map> mapType;
        protected Object focus;
        protected Stack<Object> focusStack = new Stack();
        protected Function<Object, Void> creationInPreviousFocus;
        protected Function<Object, Object> translator;

        public Navigator(Object backingStore, Class<? extends Map> mapType) {
            this.root = Preconditions.checkNotNull((Object)backingStore);
            this.focus = backingStore;
            this.mapType = mapType;
        }

        public Navigator(Class<? extends Map> mapType) {
            this.root = null;
            this.focus = null;
            this.mapType = mapType;
            this.creationInPreviousFocus = new Function<Object, Void>(){

                public Void apply(Object o) {
                    root = o;
                    return null;
                }
            };
        }

        public Object get() {
            return this.focus;
        }

        @Nonnull
        public Maybe<Object> getMaybe() {
            return Maybe.fromNullable(this.focus);
        }

        public <V> V get(Class<V> type) {
            return (V)this.focus;
        }

        @Nonnull
        public <V> Maybe<V> getMaybe(Class<V> type) {
            return Maybe.fromNullable(this.get(type));
        }

        public Object get(Object pathSegment, Object ... furtherPathSegments) {
            this.push();
            this.at(pathSegment, furtherPathSegments);
            Object result = this.get();
            this.pop();
            return result;
        }

        public Navigator<T> root() {
            this.focus = this.root;
            return this;
        }

        public Object getRoot() {
            return this.root;
        }

        public T getRootMap() {
            return (T)((Map)this.root);
        }

        public T getFocusMap() {
            this.map();
            return (T)((Map)this.focus);
        }

        @Nonnull
        public Maybe<T> getFocusMapMaybe() {
            return Maybe.fromNullable(this.getFocusMap());
        }

        public Navigator<T> useTranslator(Function<Object, Object> translator) {
            this.translator = translator;
            return this;
        }

        protected Object translate(Object x) {
            if (this.translator == null) {
                return x;
            }
            return this.translator.apply(x);
        }

        protected Object translateKey(Object x) {
            if (this.translator == null) {
                return x;
            }
            return this.translator.apply(x);
        }

        public Navigator<T> push() {
            this.focusStack.push(this.focus);
            return this;
        }

        public Navigator<T> pop() {
            this.focus = this.focusStack.pop();
            return this;
        }

        public Navigator<T> at(Object pathSegment, Object ... furtherPathSegments) {
            this.down(pathSegment, false);
            return this.atArray(furtherPathSegments);
        }

        public Navigator<T> atArray(Object[] furtherPathSegments) {
            for (Object p : furtherPathSegments) {
                this.down(p, false);
            }
            return this;
        }

        public Navigator<T> atExisting(Object pathSegment, Object ... furtherPathSegments) {
            this.down(pathSegment, true);
            return this.atArray(furtherPathSegments);
        }

        public Navigator<T> map() {
            if (this.focus == null) {
                this.focus = this.newMap();
                this.creationInPreviousFocus.apply(this.focus);
            }
            if (this.focus instanceof List) {
                Map m = this.newMap();
                ((List)this.focus).add(this.translate(m));
                this.focus = m;
                return this;
            }
            if (!(this.focus instanceof Map)) {
                throw new IllegalStateException("focus here is " + this.focus + "; expected a map");
            }
            return this;
        }

        public Navigator<T> put(Object k1, Object v1, Object ... kvOthers) {
            this.map();
            this.putInternal((Map)this.focus, k1, v1, kvOthers);
            return this;
        }

        public Navigator<T> putIfNotNull(Object k1, Object v1) {
            if (v1 != null) {
                this.map();
                this.putInternal((Map)this.focus, k1, v1, new Object[0]);
            }
            return this;
        }

        protected void putInternal(Map target, Object k1, Object v1, Object ... kvOthers) {
            assert (kvOthers.length % 2 == 0) : "even number of arguments required for put";
            target.put(this.translateKey(k1), this.translate(v1));
            int i = 0;
            while (i < kvOthers.length) {
                target.put(this.translateKey(kvOthers[i++]), this.translate(kvOthers[i++]));
            }
        }

        public Navigator<T> put(Map map) {
            this.map();
            if (map == null) {
                return this;
            }
            ((Map)this.focus).putAll((Map)this.translate(map));
            return this;
        }

        protected Map newMap() {
            try {
                return this.mapType.newInstance();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        protected Navigator<T> down(Object pathSegment, boolean requireExisting) {
            if (this.focus instanceof List) {
                return this.downList(pathSegment, requireExisting);
            }
            if (this.focus instanceof Map || this.focus == null) {
                return this.downMap(pathSegment, requireExisting);
            }
            throw new IllegalStateException("focus here is " + this.focus + "; cannot descend to '" + pathSegment + "'");
        }

        protected Navigator<T> downMap(Object pathSegmentO, boolean requireExisting) {
            final Object pathSegment = this.translateKey(pathSegmentO);
            final Map givenParentMap = (Map)this.focus;
            if (givenParentMap != null) {
                this.creationInPreviousFocus = null;
                this.focus = givenParentMap.get(pathSegment);
            }
            if (this.focus == null) {
                if (requireExisting) {
                    throw new IllegalStateException("No key '" + pathSegmentO + "' found to descend");
                }
                final Function<Object, Void> previousCreation = this.creationInPreviousFocus;
                this.creationInPreviousFocus = new Function<Object, Void>(){

                    public Void apply(Object input) {
                        creationInPreviousFocus = null;
                        Map parentMap = givenParentMap;
                        if (parentMap == null) {
                            parentMap = this.newMap();
                            previousCreation.apply((Object)parentMap);
                        }
                        parentMap.put(pathSegment, this.translate(input));
                        return null;
                    }
                };
            }
            return this;
        }

        protected Navigator<T> downList(Object pathSegment, boolean requireExisting) {
            if (!(pathSegment instanceof Integer)) {
                throw new IllegalStateException("focus here is a list (" + this.focus + "); cannot descend to '" + pathSegment + "'");
            }
            List givenParentList = (List)this.focus;
            this.creationInPreviousFocus = null;
            this.focus = givenParentList.get((Integer)pathSegment);
            if (this.focus == null) {
                if (requireExisting) {
                    throw new IllegalStateException("No index '" + pathSegment + "' found to descend");
                }
                this.creationInPreviousFocus = new Function<Object, Void>(){

                    public Void apply(Object input) {
                        throw new IllegalStateException("cannot create " + input + " here because we are at a non-existent position in a list");
                    }
                };
            }
            return this;
        }

        public Navigator<T> list() {
            if (this.focus == null) {
                this.focus = this.newList();
                this.creationInPreviousFocus.apply(this.focus);
            }
            if (!(this.focus instanceof List)) {
                throw new IllegalStateException("focus here is " + this.focus + "; expected a list");
            }
            return this;
        }

        protected List newList() {
            return new ArrayList();
        }

        public Navigator<T> add(Object o1, Object ... others) {
            if (this.focus == null) {
                if (others.length > 0) {
                    this.map();
                } else {
                    this.focus = o1;
                    if (this.creationInPreviousFocus != null) {
                        this.creationInPreviousFocus.apply(o1);
                    }
                    return this;
                }
            }
            this.addInternal(this.focus, this.focus, o1, others);
            return this;
        }

        public Navigator<T> addUnflattened(Object o1, Object ... others) {
            ((Collection)this.focus).add(this.translate(o1));
            for (Object oi : others) {
                ((Collection)this.focus).add(this.translate(oi));
            }
            return this;
        }

        protected void addInternal(Object initialFocus, Object currentFocus, Object o1, Object ... others) {
            if (currentFocus instanceof Map) {
                MutableMap<Object, Object> source;
                Map target = (Map)currentFocus;
                if (others.length == 0) {
                    if (o1 == null) {
                        return;
                    }
                    if (!(o1 instanceof Map)) {
                        throw new IllegalStateException("cannot add: focus here is " + currentFocus + " (in " + initialFocus + "); expected a collection, or a map (with a map being added, not " + o1 + ")");
                    }
                    source = (MutableMap<Object, Object>)this.translate(o1);
                } else {
                    if (others.length % 2 == 0) {
                        throw new IllegalArgumentException("cannot add an odd number of arguments to a map (" + o1 + " then " + Arrays.toString(others) + " in " + currentFocus + " in " + initialFocus + ")");
                    }
                    source = MutableMap.of(this.translateKey(o1), this.translate(others[0]));
                    int i = 1;
                    while (i < others.length) {
                        source.put(this.translateKey(others[i++]), this.translate(others[i++]));
                    }
                }
                for (Map.Entry entry : source.entrySet()) {
                    Object key = entry.getKey();
                    Object sv = entry.getValue();
                    Object tv = target.get(key);
                    if (!target.containsKey(key)) {
                        target.put(key, sv);
                        continue;
                    }
                    this.addInternal(initialFocus, tv, sv, new Object[0]);
                }
                return;
            }
            if (!(currentFocus instanceof Collection)) {
                throw new IllegalStateException("cannot add: focus here is " + currentFocus + "; expected a collection");
            }
            this.addFlattened((Collection)currentFocus, o1);
            for (Object oi : others) {
                this.addFlattened((Collection)currentFocus, oi);
            }
        }

        protected void addFlattened(Collection target, Object item) {
            if (item instanceof Iterable) {
                for (Object i : (Iterable)item) {
                    this.addFlattened(target, i);
                }
                return;
            }
            if (item.getClass().isArray()) {
                for (Object i : (Object[])item) {
                    this.addFlattened(target, i);
                }
                return;
            }
            target.add(this.translate(item));
        }

        public String toString() {
            return Jsonya.render(this.get());
        }
    }
}

