/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import org.jclouds.gogrid.domain.IpState;
import org.jclouds.gogrid.domain.IpType;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetIpListOptions
extends BaseHttpRequestOptions {
    public static final GetIpListOptions NONE = new GetIpListOptions();

    public GetIpListOptions onlyAssigned() {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"ip.state") ? 1 : 0) != 0, (Object)"Can't have multiple values for whether IP is assigned");
        this.queryParameters.put((Object)"ip.state", (Object)IpState.ASSIGNED.toString());
        return this;
    }

    public GetIpListOptions onlyUnassigned() {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"ip.state") ? 1 : 0) != 0, (Object)"Can't have multiple values for whether IP is assigned");
        this.queryParameters.put((Object)"ip.state", (Object)IpState.UNASSIGNED.toString());
        return this;
    }

    public GetIpListOptions onlyWithType(IpType type) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"ip.type") ? 1 : 0) != 0, (Object)"Can't have multiple values for ip type limit");
        this.queryParameters.put((Object)"ip.type", (Object)type.toString());
        return this;
    }

    public GetIpListOptions inDatacenter(String datacenterId) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"datacenter") ? 1 : 0) != 0, (Object)"Can't have duplicate datacenter id");
        this.queryParameters.put((Object)"datacenter", (Object)datacenterId);
        return this;
    }

    public static class Builder {
        public GetIpListOptions inDatacenter(String datacenterId) {
            return new GetIpListOptions().inDatacenter((String)Preconditions.checkNotNull((Object)datacenterId));
        }

        public GetIpListOptions create() {
            return new GetIpListOptions();
        }

        public GetIpListOptions limitToType(IpType type) {
            return new GetIpListOptions().onlyWithType(type);
        }

        public GetIpListOptions unassignedPublicIps() {
            return new GetIpListOptions().onlyWithType(IpType.PUBLIC).onlyUnassigned();
        }
    }
}

