/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.api.ScriptApi;
import org.apache.brooklyn.rest.domain.ScriptExecutionSummary;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.util.MultiSessionAttributeAdapter;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.stream.ThreadLocalPrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptResource
extends AbstractBrooklynRestResource
implements ScriptApi {
    private static final Logger log = LoggerFactory.getLogger(ScriptResource.class);
    public static final String USER_DATA_MAP_SESSION_ATTRIBUTE = "brooklyn.script.groovy.user.data";
    public static final String USER_LAST_VALUE_SESSION_ATTRIBUTE = "brooklyn.script.groovy.user.last";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptExecutionSummary groovy(HttpServletRequest request, String script) {
        MultiSessionAttributeAdapter session;
        boolean entitledGS = Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.EXECUTE_GROOVY_SCRIPT, null);
        boolean entitledS = Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.EXECUTE_SCRIPT, null);
        if (!entitledS || !entitledGS) {
            if (entitledGS) {
                log.warn("User '" + Entitlements.getEntitlementContext().user() + "' is entitled to run groovy scripts but not scripts. The two permissions should be equivalent and the former may be removed, blocking access. Either grant permission to execute scripts or remove permission to execute groovy scripts.");
            } else {
                throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
            }
        }
        log.info("Web REST executing user-supplied script");
        if (log.isDebugEnabled()) {
            log.debug("Web REST user-supplied script contents:\n" + script);
        }
        Binding binding = new Binding();
        binding.setVariable("mgmt", (Object)this.mgmt());
        MultiSessionAttributeAdapter multiSessionAttributeAdapter = session = request == null ? null : MultiSessionAttributeAdapter.of(request);
        if (session != null) {
            LinkedHashMap data = (LinkedHashMap)session.getAttribute(USER_DATA_MAP_SESSION_ATTRIBUTE);
            if (data == null) {
                data = new LinkedHashMap();
                session.setAttribute(USER_DATA_MAP_SESSION_ATTRIBUTE, data);
            }
            binding.setVariable("data", data);
            Object last = session.getAttribute(USER_LAST_VALUE_SESSION_ATTRIBUTE);
            binding.setVariable("last", last);
        }
        GroovyShell shell = new GroovyShell(binding);
        ThreadLocalPrintStream.OutputCapturingContext stdout = ThreadLocalPrintStream.stdout().captureTee();
        ThreadLocalPrintStream.OutputCapturingContext stderr = ThreadLocalPrintStream.stderr().captureTee();
        Object value = null;
        Throwable problem = null;
        try {
            value = shell.evaluate(script);
            if (session != null) {
                session.setAttribute(USER_LAST_VALUE_SESSION_ATTRIBUTE, value);
            }
        }
        catch (Throwable t) {
            log.warn("Problem in user-supplied script: " + t, t);
            problem = t;
        }
        finally {
            stdout.end();
            stderr.end();
        }
        if (log.isDebugEnabled()) {
            log.debug("Web REST user-supplied script completed:\n" + (value != null ? "RESULT: " + value.toString() + "\n" : "") + (problem != null ? "ERROR: " + problem.toString() + "\n" : "") + (!stdout.isEmpty() ? "STDOUT: " + stdout.toString() + "\n" : "") + (!stderr.isEmpty() ? "STDERR: " + stderr.toString() + "\n" : ""));
        }
        return new ScriptExecutionSummary((Object)(value != null ? value.toString() : null), problem != null ? problem.toString() : null, stdout.toString(), stderr.toString());
    }
}

