/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;

public class TestHttpServer {
    private HttpServer server;
    private List<HttpRequestInterceptor> requestInterceptors = MutableList.of();
    private List<HttpResponseInterceptor> responseInterceptors = MutableList.of(new ResponseContent(), new ResponseConnControl());
    private int basePort = 50505;
    private Collection<HandlerTuple> handlers = MutableList.of();

    public TestHttpServer interceptor(HttpResponseInterceptor interceptor) {
        this.checkNotStarted();
        this.responseInterceptors.add(interceptor);
        return this;
    }

    public TestHttpServer responseInterceptors(List<HttpResponseInterceptor> interceptors) {
        this.checkNotStarted();
        this.responseInterceptors = interceptors;
        return this;
    }

    public TestHttpServer interceptor(HttpRequestInterceptor interceptor) {
        this.checkNotStarted();
        this.requestInterceptors.add(interceptor);
        return this;
    }

    public TestHttpServer requestInterceptors(List<HttpRequestInterceptor> interceptors) {
        this.checkNotStarted();
        this.requestInterceptors = interceptors;
        return this;
    }

    public TestHttpServer basePort(int basePort) {
        this.checkNotStarted();
        this.basePort = basePort;
        return this;
    }

    public TestHttpServer handler(String path, HttpRequestHandler handler) {
        this.checkNotStarted();
        this.handlers.add(new HandlerTuple(path, handler));
        return this;
    }

    public TestHttpServer start() {
        this.checkNotStarted();
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(this.requestInterceptors, this.responseInterceptors);
        int port = Networking.nextAvailablePort(this.basePort);
        ServerBootstrap bootstrap = ServerBootstrap.bootstrap().setListenerPort(port).setLocalAddress(this.getLocalAddress()).setHttpProcessor((HttpProcessor)httpProcessor);
        for (HandlerTuple tuple : this.handlers) {
            bootstrap.registerHandler(tuple.path, tuple.handler);
        }
        this.server = bootstrap.create();
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
        return this;
    }

    public void stop() {
        if (null != this.server) {
            this.server.stop();
            this.server = null;
        }
    }

    private void checkNotStarted() {
        if (this.server != null) {
            throw new IllegalStateException("Server already started");
        }
    }

    private InetAddress getLocalAddress() {
        return InetAddress.getLoopbackAddress();
    }

    public String getUrl() {
        try {
            if (this.server == null) {
                return new URL("http", this.getLocalAddress().getHostAddress(), this.basePort, "").toExternalForm();
            }
            return new URL("http", this.server.getInetAddress().getHostAddress(), this.server.getLocalPort(), "").toExternalForm();
        }
        catch (MalformedURLException e) {
            throw Exceptions.propagate(e);
        }
    }

    private static class HandlerTuple {
        String path;
        HttpRequestHandler handler;

        public HandlerTuple(String path, HttpRequestHandler handler) {
            this.path = path;
            this.handler = handler;
        }
    }
}

