/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.camp.AggregatingCampPlatform;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynEntityMatcher;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslInterpreter;
import org.apache.brooklyn.camp.brooklyn.spi.platform.BrooklynImmutableCampPlatform;
import org.apache.brooklyn.camp.spi.PlatformRootSummary;
import org.apache.brooklyn.camp.spi.resolve.PdpMatcher;
import org.apache.brooklyn.camp.spi.resolve.PlanInterpreter;
import org.apache.brooklyn.core.mgmt.HasBrooklynManagementContext;
import org.apache.brooklyn.core.mgmt.internal.CampYamlParser;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;

public class BrooklynCampPlatform
extends AggregatingCampPlatform
implements HasBrooklynManagementContext {
    private final ManagementContext bmc;

    public BrooklynCampPlatform(PlatformRootSummary root, ManagementContext managementContext) {
        super(root);
        this.addPlatform(new BrooklynImmutableCampPlatform(root, managementContext));
        this.bmc = managementContext;
        this.addMatchers();
        this.addInterpreters();
        managementContext.addPropertiesReloadListener(new ManagementContext.PropertiesReloadListener(){
            private static final long serialVersionUID = -3739276553334749184L;

            public void reloaded() {
                BrooklynCampPlatform.this.setConfigKeyAtManagmentContext();
            }
        });
    }

    @Nullable
    public static CampPlatform findPlatform(ManagementContext mgmt) {
        return (CampPlatform)mgmt.getScratchpad().get(BrooklynCampConstants.CAMP_PLATFORM);
    }

    public ManagementContext getBrooklynManagementContext() {
        return this.bmc;
    }

    protected void addMatchers() {
        this.pdp().addMatcher((PdpMatcher)new BrooklynEntityMatcher(this.bmc));
    }

    protected void addInterpreters() {
        this.pdp().addInterpreter((PlanInterpreter)new BrooklynDslInterpreter());
    }

    public BrooklynCampPlatform setConfigKeyAtManagmentContext() {
        ((ManagementContextInternal)this.bmc).getBrooklynProperties().put(BrooklynCampConstants.CAMP_PLATFORM, (Object)this);
        ((ManagementContextInternal)this.bmc).getBrooklynProperties().put(CampYamlParser.YAML_PARSER_KEY, (Object)new YamlParserImpl(this));
        this.bmc.getScratchpad().put(BrooklynCampConstants.CAMP_PLATFORM, (Object)this);
        this.bmc.getScratchpad().put(CampYamlParser.YAML_PARSER_KEY, (Object)new YamlParserImpl(this));
        return this;
    }

    public static class YamlParserImpl
    implements CampYamlParser {
        private final BrooklynCampPlatform platform;

        YamlParserImpl(BrooklynCampPlatform platform) {
            this.platform = platform;
        }

        public Map<String, Object> parse(Map<String, Object> map) {
            return this.platform.pdp().applyInterpreters(map);
        }

        public Object parse(String val) {
            Map result = this.platform.pdp().applyInterpreters((Map)ImmutableMap.of((Object)"dummyKey", (Object)val));
            Preconditions.checkState((boolean)result.keySet().equals(ImmutableSet.of((Object)"dummyKey")), (String)"expected single result, but got %s", (Object[])new Object[]{result});
            return result.get("dummyKey");
        }
    }
}

