/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeStatus;
import io.fabric8.kubernetes.api.model.PersistentVolumeStatusBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluentImpl;

public class PersistentVolumeFluentImpl<A extends PersistentVolumeFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends PersistentVolumeSpec, ?> spec;
    private VisitableBuilder<? extends PersistentVolumeStatus, ?> status;

    public PersistentVolumeFluentImpl() {
    }

    public PersistentVolumeFluentImpl(PersistentVolume instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public PersistentVolumeSpec getSpec() {
        return this.spec != null ? (PersistentVolumeSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(PersistentVolumeSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new PersistentVolumeSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> withNewSpecLike(PersistentVolumeSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new PersistentVolumeSpecBuilder().build());
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> editOrNewSpecLike(PersistentVolumeSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    public PersistentVolumeStatus getStatus() {
        return this.status != null ? (PersistentVolumeStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(PersistentVolumeStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new PersistentVolumeStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> withNewStatusLike(PersistentVolumeStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new PersistentVolumeStatusBuilder().build());
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> editOrNewStatusLike(PersistentVolumeStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A withNewStatus(String message, String phase, String reason) {
        return this.withStatus(new PersistentVolumeStatus(message, phase, reason));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeFluentImpl that = (PersistentVolumeFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends PersistentVolumeStatusFluentImpl<PersistentVolumeFluent.StatusNested<N>>
    implements PersistentVolumeFluent.StatusNested<N>,
    Nested<N> {
        private final PersistentVolumeStatusBuilder builder;

        StatusNestedImpl(PersistentVolumeStatus item) {
            this.builder = new PersistentVolumeStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new PersistentVolumeStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends PersistentVolumeSpecFluentImpl<PersistentVolumeFluent.SpecNested<N>>
    implements PersistentVolumeFluent.SpecNested<N>,
    Nested<N> {
        private final PersistentVolumeSpecBuilder builder;

        SpecNestedImpl(PersistentVolumeSpec item) {
            this.builder = new PersistentVolumeSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new PersistentVolumeSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PersistentVolumeFluent.MetadataNested<N>>
    implements PersistentVolumeFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

