/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.http;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.MaybeFunctions;

public class JsonFunctions {
    private JsonFunctions() {
    }

    @Deprecated
    private static Function<String, JsonElement> asJsonOld() {
        return new Function<String, JsonElement>(){

            public JsonElement apply(String input) {
                return new JsonParser().parse(input);
            }
        };
    }

    @Deprecated
    private static <T> Function<JsonElement, List<T>> forEachOld(final Function<JsonElement, T> func) {
        return new Function<JsonElement, List<T>>(){

            public List<T> apply(JsonElement input) {
                JsonArray array = (JsonArray)input;
                ArrayList result = Lists.newArrayList();
                for (int i = 0; i < array.size(); ++i) {
                    result.add(func.apply((Object)array.get(i)));
                }
                return result;
            }
        };
    }

    @Deprecated
    private static Function<JsonElement, JsonElement> walkOld(final Iterable<String> elements) {
        return new Function<JsonElement, JsonElement>(){

            public JsonElement apply(JsonElement input) {
                JsonElement curr = input;
                for (String element : elements) {
                    JsonObject jo = curr.getAsJsonObject();
                    if ((curr = jo.get(element)) != null) continue;
                    throw new NoSuchElementException("No element '" + element + " in JSON, when walking " + elements);
                }
                return curr;
            }
        };
    }

    @Deprecated
    private static Function<JsonElement, JsonElement> walkNOld(final Iterable<String> elements) {
        return new Function<JsonElement, JsonElement>(){

            public JsonElement apply(JsonElement input) {
                JsonElement curr = input;
                for (String element : elements) {
                    if (curr == null) {
                        return null;
                    }
                    JsonObject jo = curr.getAsJsonObject();
                    curr = jo.get(element);
                }
                return curr;
            }
        };
    }

    @Deprecated
    private static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkMOld(final Iterable<String> elements) {
        return new Function<Maybe<JsonElement>, Maybe<JsonElement>>(){

            public Maybe<JsonElement> apply(Maybe<JsonElement> input) {
                Maybe curr = input;
                for (String element : elements) {
                    if (curr.isAbsent()) {
                        return curr;
                    }
                    JsonObject jo = ((JsonElement)curr.get()).getAsJsonObject();
                    JsonElement currO = jo.get(element);
                    if (currO == null) {
                        return Maybe.absent((String)("No element '" + element + " in JSON, when walking " + elements));
                    }
                    curr = Maybe.of((Object)currO);
                }
                return curr;
            }
        };
    }

    @Deprecated
    private static <T> Function<JsonElement, T> getPathOld(final String path) {
        return new Function<JsonElement, T>(){

            public T apply(JsonElement input) {
                String jsonString = input.toString();
                Object rawElement = JsonPath.read((String)jsonString, (String)path, (Predicate[])new Predicate[0]);
                return rawElement;
            }
        };
    }

    @Deprecated
    private static <T> Function<JsonElement, T> castOld(final Class<T> expected) {
        return new Function<JsonElement, T>(){

            public T apply(JsonElement input) {
                return JsonFunctions.doCast(input, expected);
            }
        };
    }

    @Deprecated
    private static <T> Function<Maybe<JsonElement>, T> castMOld(final Class<T> expected, final T defaultValue) {
        return new Function<Maybe<JsonElement>, T>(){

            public T apply(Maybe<JsonElement> input) {
                if (input.isAbsent()) {
                    return defaultValue;
                }
                return JsonFunctions.cast(expected).apply(input.get());
            }
        };
    }

    public static Function<String, JsonElement> asJson() {
        return new AsJson();
    }

    public static <T> Function<JsonElement, List<T>> forEach(Function<JsonElement, T> func) {
        return new ForEach<T>(func);
    }

    public static Function<JsonElement, JsonElement> walk(String elementOrDotSeparatedElements) {
        return JsonFunctions.walk(Splitter.on((char)'.').split((CharSequence)elementOrDotSeparatedElements));
    }

    public static Function<JsonElement, JsonElement> walk(String ... elements) {
        return JsonFunctions.walk(Arrays.asList(elements));
    }

    public static Function<JsonElement, JsonElement> walk(Iterable<String> elements) {
        return new Walk(elements);
    }

    public static Function<JsonElement, JsonElement> walkN(@Nullable String elements) {
        return JsonFunctions.walkN(Splitter.on((char)'.').split((CharSequence)elements));
    }

    public static Function<JsonElement, JsonElement> walkN(String ... elements) {
        return JsonFunctions.walkN(Arrays.asList(elements));
    }

    public static Function<JsonElement, JsonElement> walkN(Iterable<String> elements) {
        return new WalkN(elements);
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(@Nullable String elements) {
        return JsonFunctions.walkM(Splitter.on((char)'.').split((CharSequence)elements));
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(String ... elements) {
        return JsonFunctions.walkM(Arrays.asList(elements));
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(Iterable<String> elements) {
        return new WalkM(elements);
    }

    public static <T> Function<JsonElement, T> getPath(String path) {
        return new GetPath(path);
    }

    public static <T> Function<JsonElement, T> cast(Class<T> expected) {
        return new Cast<T>(expected);
    }

    protected static <T> T doCast(JsonElement input, Class<T> expected) {
        if (input == null) {
            return null;
        }
        if (input.isJsonNull()) {
            return null;
        }
        if (expected == Boolean.TYPE || expected == Boolean.class) {
            return (T)Boolean.valueOf(input.getAsBoolean());
        }
        if (expected == Character.TYPE || expected == Character.class) {
            return (T)Character.valueOf(input.getAsCharacter());
        }
        if (expected == Byte.TYPE || expected == Byte.class) {
            return (T)Byte.valueOf(input.getAsByte());
        }
        if (expected == Short.TYPE || expected == Short.class) {
            return (T)Short.valueOf(input.getAsShort());
        }
        if (expected == Integer.TYPE || expected == Integer.class) {
            return (T)Integer.valueOf(input.getAsInt());
        }
        if (expected == Long.TYPE || expected == Long.class) {
            return (T)Long.valueOf(input.getAsLong());
        }
        if (expected == Float.TYPE || expected == Float.class) {
            return (T)Float.valueOf(input.getAsFloat());
        }
        if (expected == Double.TYPE || expected == Double.class) {
            return (T)Double.valueOf(input.getAsDouble());
        }
        if (expected == BigDecimal.class) {
            return (T)input.getAsBigDecimal();
        }
        if (expected == BigInteger.class) {
            return (T)input.getAsBigInteger();
        }
        if (Number.class.isAssignableFrom(expected)) {
            return (T)input.getAsNumber();
        }
        if (expected == String.class) {
            return (T)input.getAsString();
        }
        if (expected.isArray()) {
            JsonArray array = input.getAsJsonArray();
            Class<?> componentType = expected.getComponentType();
            if (JsonElement.class.isAssignableFrom(componentType)) {
                JsonElement[] result = new JsonElement[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    result[i] = array.get(i);
                }
                return (T)result;
            }
            Object[] result = (Object[])Array.newInstance(componentType, array.size());
            for (int i = 0; i < array.size(); ++i) {
                result[i] = JsonFunctions.cast(componentType).apply((Object)array.get(i));
            }
            return (T)result;
        }
        throw new IllegalArgumentException("Cannot cast json element to type " + expected);
    }

    public static <T> Function<Maybe<JsonElement>, T> castM(Class<T> expected) {
        return Functionals.chain((Function)MaybeFunctions.get(), JsonFunctions.cast(expected));
    }

    public static <T> Function<Maybe<JsonElement>, T> castM(Class<T> expected, T defaultValue) {
        return new CastM<T>(expected, defaultValue);
    }

    protected static class CastM<T>
    implements Function<Maybe<JsonElement>, T> {
        private final Class<T> expected;
        private final T defaultValue;

        public CastM(Class<T> expected, T defaultValue) {
            this.expected = expected;
            this.defaultValue = defaultValue;
        }

        public T apply(Maybe<JsonElement> input) {
            if (input.isAbsent()) {
                return this.defaultValue;
            }
            return (T)JsonFunctions.cast(this.expected).apply(input.get());
        }
    }

    protected static class Cast<T>
    implements Function<JsonElement, T> {
        private final Class<T> expected;

        public Cast(Class<T> expected) {
            this.expected = expected;
        }

        public T apply(JsonElement input) {
            return JsonFunctions.doCast(input, this.expected);
        }
    }

    protected static class GetPath<T>
    implements Function<JsonElement, T> {
        private final String path;

        public GetPath(String path) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
        }

        public T apply(JsonElement input) {
            if (input == null) {
                return null;
            }
            String jsonString = input.toString();
            Object rawElement = JsonPath.read((String)jsonString, (String)this.path, (Predicate[])new Predicate[0]);
            return (T)rawElement;
        }
    }

    protected static class WalkM
    implements Function<Maybe<JsonElement>, Maybe<JsonElement>> {
        private final Iterable<String> elements;

        public WalkM(Iterable<String> elements) {
            this.elements = elements;
        }

        public Maybe<JsonElement> apply(Maybe<JsonElement> input) {
            Maybe curr = input;
            for (String element : this.elements) {
                if (curr.isAbsent()) {
                    return curr;
                }
                JsonObject jo = ((JsonElement)curr.get()).getAsJsonObject();
                JsonElement currO = jo.get(element);
                if (currO == null) {
                    return Maybe.absent((String)("No element '" + element + " in JSON, when walking " + this.elements));
                }
                curr = Maybe.of((Object)currO);
            }
            return curr;
        }
    }

    protected static class WalkN
    implements Function<JsonElement, JsonElement> {
        private final Iterable<String> elements;

        public WalkN(Iterable<String> elements) {
            this.elements = elements;
        }

        public JsonElement apply(JsonElement input) {
            JsonElement curr = input;
            for (String element : this.elements) {
                if (curr == null) {
                    return null;
                }
                JsonObject jo = curr.getAsJsonObject();
                curr = jo.get(element);
            }
            return curr;
        }
    }

    protected static class Walk
    implements Function<JsonElement, JsonElement> {
        private final Iterable<String> elements;

        public Walk(Iterable<String> elements) {
            this.elements = elements;
        }

        public JsonElement apply(JsonElement input) {
            JsonElement curr = input;
            for (String element : this.elements) {
                JsonObject jo = curr.getAsJsonObject();
                if ((curr = jo.get(element)) != null) continue;
                throw new NoSuchElementException("No element '" + element + " in JSON, when walking " + this.elements);
            }
            return curr;
        }
    }

    protected static class ForEach<T>
    implements Function<JsonElement, List<T>> {
        private final Function<JsonElement, T> func;

        public ForEach(Function<JsonElement, T> func) {
            this.func = func;
        }

        public List<T> apply(JsonElement input) {
            JsonArray array = (JsonArray)input;
            ArrayList result = Lists.newArrayList();
            for (int i = 0; i < array.size(); ++i) {
                result.add(this.func.apply((Object)array.get(i)));
            }
            return result;
        }
    }

    protected static class AsJson
    implements Function<String, JsonElement> {
        protected AsJson() {
        }

        public JsonElement apply(String input) {
            return input != null ? new JsonParser().parse(input) : null;
        }
    }
}

