/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.function;

import com.google.common.annotations.Beta;
import com.google.common.base.Functions;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.sensor.AbstractAddSensorFeed;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class FunctionSensor<T>
extends AbstractAddSensorFeed<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionSensor.class);
    public static final ConfigKey<Callable<?>> FUNCTION = ConfigKeys.newConfigKey(new TypeToken<Callable<?>>(){}, "function", "The callable to be executed periodically", null);

    public FunctionSensor(ConfigBag params) {
        super(params);
    }

    @Override
    public void apply(EntityLocal entity) {
        super.apply(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding HTTP JSON sensor {} to {}", (Object)this.name, (Object)entity);
        }
        ConfigBag allConfig = ConfigBag.newInstanceCopying(this.params).putAll(this.params);
        Callable<?> function = EntityInitializers.resolve(allConfig, FUNCTION);
        Boolean suppressDuplicates = (Boolean)EntityInitializers.resolve(allConfig, SUPPRESS_DUPLICATES);
        Duration logWarningGraceTimeOnStartup = (Duration)EntityInitializers.resolve(allConfig, LOG_WARNING_GRACE_TIME_ON_STARTUP);
        Duration logWarningGraceTime = (Duration)EntityInitializers.resolve(allConfig, LOG_WARNING_GRACE_TIME);
        FunctionPollConfig pollConfig = (FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(this.sensor).callable(function).onFailureOrException(Functions.constant(null))).suppressDuplicates(Boolean.TRUE.equals(suppressDuplicates))).logWarningGraceTimeOnStartup(logWarningGraceTimeOnStartup)).logWarningGraceTime(logWarningGraceTime)).period(this.period);
        FunctionFeed feed = FunctionFeed.builder().entity((Entity)entity).poll(pollConfig).build();
        entity.addFeed((Feed)feed);
    }
}

