/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.ISO;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListISOsOptions
extends AccountInDomainOptions {
    public static final ListISOsOptions NONE = new ListISOsOptions();
    private static final Set<String> TRUE = ImmutableSet.of((Object)Boolean.toString(true));
    private static final Set<String> FALSE = ImmutableSet.of((Object)Boolean.toString(false));

    public ListISOsOptions bootable() {
        this.queryParameters.replaceValues((Object)"bootable", TRUE);
        return this;
    }

    public ListISOsOptions notBootable() {
        this.queryParameters.replaceValues((Object)"bootable", FALSE);
        return this;
    }

    public ListISOsOptions hypervisor(String hypervisor) {
        this.queryParameters.replaceValues((Object)"hypervisor", (Iterable)ImmutableSet.of((Object)hypervisor));
        return this;
    }

    public ListISOsOptions id(String id) {
        this.queryParameters.replaceValues((Object)"id", (Iterable)ImmutableSet.of((Object)id));
        return this;
    }

    public ListISOsOptions projectId(String projectId) {
        this.queryParameters.replaceValues((Object)"projectid", (Iterable)ImmutableSet.of((Object)(projectId + "")));
        return this;
    }

    public ListISOsOptions isoFilter(ISO.ISOFilter isoFilter) {
        this.queryParameters.replaceValues((Object)"isofilter", (Iterable)ImmutableSet.of((Object)isoFilter.name()));
        return this;
    }

    public ListISOsOptions isPublic() {
        this.queryParameters.replaceValues((Object)"ispublic", TRUE);
        return this;
    }

    public ListISOsOptions isPrivate() {
        this.queryParameters.replaceValues((Object)"ispublic", FALSE);
        return this;
    }

    public ListISOsOptions isReady() {
        this.queryParameters.replaceValues((Object)"isready", TRUE);
        return this;
    }

    public ListISOsOptions isNotReady() {
        this.queryParameters.replaceValues((Object)"isready", FALSE);
        return this;
    }

    public ListISOsOptions keyword(String keyword) {
        this.queryParameters.replaceValues((Object)"keyword", (Iterable)ImmutableSet.of((Object)keyword));
        return this;
    }

    public ListISOsOptions name(String name) {
        this.queryParameters.replaceValues((Object)"name", (Iterable)ImmutableSet.of((Object)name));
        return this;
    }

    public ListISOsOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues((Object)"zoneid", (Iterable)ImmutableSet.of((Object)zoneId));
        return this;
    }

    public ListISOsOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues((Object)String.format("tags[%d].key", count), (Iterable)ImmutableSet.of((Object)entry.getKey()));
            this.queryParameters.replaceValues((Object)String.format("tags[%d].value", count), (Iterable)ImmutableSet.of((Object)entry.getValue()));
            ++count;
        }
        return this;
    }

    public static class Builder {
        public static ListISOsOptions accountInDomain(String account, String domainId) {
            return (ListISOsOptions)new ListISOsOptions().accountInDomain(account, domainId);
        }

        public static ListISOsOptions bootable() {
            return new ListISOsOptions().bootable();
        }

        public static ListISOsOptions notBootable() {
            return new ListISOsOptions().notBootable();
        }

        public static ListISOsOptions domainId(String domainId) {
            return (ListISOsOptions)new ListISOsOptions().domainId(domainId);
        }

        public static ListISOsOptions hypervisor(String hypervisor) {
            return new ListISOsOptions().hypervisor(hypervisor);
        }

        public static ListISOsOptions id(String id) {
            return new ListISOsOptions().id(id);
        }

        public static ListISOsOptions projectId(String projectId) {
            return new ListISOsOptions().projectId(projectId);
        }

        public static ListISOsOptions isoFilter(ISO.ISOFilter isoFilter) {
            return new ListISOsOptions().isoFilter(isoFilter);
        }

        public static ListISOsOptions isPublic() {
            return new ListISOsOptions().isPublic();
        }

        public static ListISOsOptions isPrivate() {
            return new ListISOsOptions().isPrivate();
        }

        public static ListISOsOptions isReady() {
            return new ListISOsOptions().isReady();
        }

        public static ListISOsOptions isNotReady() {
            return new ListISOsOptions().isNotReady();
        }

        public static ListISOsOptions keyword(String keyword) {
            return new ListISOsOptions().keyword(keyword);
        }

        public static ListISOsOptions name(String name) {
            return new ListISOsOptions().name(name);
        }

        public static ListISOsOptions zoneId(String zoneId) {
            return new ListISOsOptions().zoneId(zoneId);
        }

        public static ListISOsOptions tags(Map<String, String> tags) {
            return new ListISOsOptions().tags(tags);
        }
    }
}

