/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.WinRmClient;
import io.cloudsoft.winrm4j.client.WinRmClientContext;
import io.cloudsoft.winrm4j.client.retry.RetryPolicy;
import io.cloudsoft.winrm4j.client.retry.SimpleCounterRetryPolicy;
import io.cloudsoft.winrm4j.client.wsman.Locale;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class WinRmClientBuilder {
    private static final java.util.Locale DEFAULT_LOCALE = java.util.Locale.US;
    private static final long DEFAULT_CONNECTION_TIMEOUT = 30000L;
    private static final long DEFAULT_CONNECTION_REQUEST_TIMEOUT = 60000L;
    private static final Long DEFAULT_RECEIVE_TIMEOUT = null;
    private static final Long DEFAULT_OPERATION_TIMEOUT = 60000L;
    private static final int DEFAULT_RETRIES_FOR_CONNECTION_FAILURES = 1;
    private static final long DEFAULT_PAUSE_BETWEEN_RETRIES = 5L;
    protected WinRmClientContext context;
    protected final URL endpoint;
    protected String authenticationScheme;
    protected String domain;
    protected String username;
    protected String password;
    protected String workingDirectory;
    protected Locale locale;
    protected long operationTimeout;
    protected Predicate<String> retryReceiveAfterOperationTimeout;
    protected long connectionTimeout;
    protected long connectionRequestTimeout;
    protected Long receiveTimeout;
    protected RetryPolicy failureRetryPolicy;
    protected Map<String, String> environment;
    protected boolean disableCertificateChecks;
    protected HostnameVerifier hostnameVerifier;
    protected SSLSocketFactory sslSocketFactory;
    protected SSLContext sslContext;
    protected boolean requestNewKerberosTicket;

    WinRmClientBuilder(String endpoint) {
        this(WinRmClientBuilder.toUrlUnchecked(WinRmClient.checkNotNull(endpoint, "endpoint")));
    }

    WinRmClientBuilder(URL endpoint) {
        this.endpoint = WinRmClient.checkNotNull(endpoint, "endpoint");
        this.authenticationScheme("NTLM");
        this.locale(DEFAULT_LOCALE);
        this.operationTimeout(DEFAULT_OPERATION_TIMEOUT);
        this.retryReceiveAfterOperationTimeout(WinRmClientBuilder.alwaysRetryReceiveAfterOperationTimeout());
        this.connectionTimeout(30000L);
        this.connectionRequestTimeout(60000L);
        this.receiveTimeout(DEFAULT_RECEIVE_TIMEOUT);
        this.retriesForConnectionFailures(1);
    }

    public WinRmClientBuilder authenticationScheme(String authenticationScheme) {
        this.authenticationScheme = WinRmClient.checkNotNull(authenticationScheme, "authenticationScheme");
        return this;
    }

    public WinRmClientBuilder credentials(String username, String password) {
        return this.credentials(null, username, password);
    }

    public WinRmClientBuilder credentials(String domain, String username, String password) {
        this.domain = domain;
        this.username = WinRmClient.checkNotNull(username, "username");
        this.password = WinRmClient.checkNotNull(password, "password");
        return this;
    }

    public WinRmClientBuilder locale(java.util.Locale locale) {
        Locale l = new Locale();
        l.setLang(WinRmClient.checkNotNull(locale, "locale").toLanguageTag());
        this.locale = l;
        return this;
    }

    public WinRmClientBuilder operationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    public WinRmClientBuilder connectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public WinRmClientBuilder connectionRequestTimeout(long connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public WinRmClientBuilder receiveTimeout(Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        return this;
    }

    public WinRmClientBuilder retryReceiveAfterOperationTimeout(Predicate<String> retryReceiveAfterOperationTimeout) {
        this.retryReceiveAfterOperationTimeout = retryReceiveAfterOperationTimeout;
        return this;
    }

    public static Predicate<String> alwaysRetryReceiveAfterOperationTimeout() {
        return x -> true;
    }

    public static Predicate<String> neverRetryReceiveAfterOperationTimeout() {
        return x -> false;
    }

    @Deprecated
    public WinRmClientBuilder retriesForConnectionFailures(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("retriesConnectionFailure should be zero or more");
        }
        this.failureRetryPolicy(WinRmClientBuilder.simpleCounterRetryPolicy(maxRetries));
        return this;
    }

    public WinRmClientBuilder failureRetryPolicy(RetryPolicy failureRetryPolicy) {
        this.failureRetryPolicy = failureRetryPolicy;
        return this;
    }

    public static RetryPolicy simpleCounterRetryPolicy(int maxRetries) {
        return new SimpleCounterRetryPolicy(maxRetries, 5L, TimeUnit.SECONDS);
    }

    public WinRmClientBuilder disableCertificateChecks(boolean disableCertificateChecks) {
        this.disableCertificateChecks = disableCertificateChecks;
        return this;
    }

    public WinRmClientBuilder workingDirectory(String workingDirectory) {
        this.workingDirectory = WinRmClient.checkNotNull(workingDirectory, "workingDirectory");
        return this;
    }

    public WinRmClientBuilder environment(Map<String, String> environment) {
        this.environment = WinRmClient.checkNotNull(environment, "environment");
        return this;
    }

    public WinRmClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public WinRmClientBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public WinRmClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public WinRmClientBuilder context(WinRmClientContext context) {
        this.context = context;
        return this;
    }

    public WinRmClientBuilder requestNewKerberosTicket(boolean requestNewKerberosTicket) {
        this.requestNewKerberosTicket = requestNewKerberosTicket;
        return this;
    }

    public WinRmClient build() {
        return new WinRmClient(this);
    }

    protected static URL toUrlUnchecked(String endpoint) {
        try {
            return new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

