/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.Rule;
import org.jclouds.openstack.neutron.v2.domain.RuleDirection;
import org.jclouds.openstack.neutron.v2.domain.RuleProtocol;
import org.jclouds.openstack.neutron.v2.domain.SecurityGroup;
import org.jclouds.openstack.neutron.v2.features.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.NeutronSecurityGroupToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;
import org.jclouds.rest.ApiContext;

@Singleton
public class CreateSecurityGroupIfNeeded
implements Function<RegionSecurityGroupNameAndPorts, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;
    private final Supplier<Map<String, Location>> locationIndex;
    private final Function<SecurityGroupInRegion, SecurityGroup> securityGroupInRegionSecurityGroupFunction;
    private final NeutronSecurityGroupToSecurityGroup.Factory neutronSecurityGroupToSecurityGroup;
    @Inject(optional=true)
    @Named(value="openstack-neutron")
    Supplier<Context> neutronContextSupplier;

    @Inject
    @VisibleForTesting
    public CreateSecurityGroupIfNeeded(NovaApi novaApi, Supplier<Map<String, Location>> locationIndex, Function<SecurityGroupInRegion, SecurityGroup> securityGroupInRegionSecurityGroupFunction, NeutronSecurityGroupToSecurityGroup.Factory neutronSecurityGroupToSecurityGroup) {
        this.novaApi = novaApi;
        this.locationIndex = locationIndex;
        this.securityGroupInRegionSecurityGroupFunction = securityGroupInRegionSecurityGroupFunction;
        this.neutronSecurityGroupToSecurityGroup = neutronSecurityGroupToSecurityGroup;
    }

    public SecurityGroup apply(RegionSecurityGroupNameAndPorts regionSecurityGroupNameAndPorts) {
        String regionId = regionSecurityGroupNameAndPorts.getRegion();
        Location location = (Location)((Map)this.locationIndex.get()).get(regionId);
        this.logger.debug(">> creating securityGroup %s", new Object[]{regionSecurityGroupNameAndPorts});
        SecurityGroupApi securityGroupApi = this.getNeutronSecurityGroupApi(regionId);
        if (securityGroupApi != null) {
            org.jclouds.openstack.neutron.v2.domain.SecurityGroup group = securityGroupApi.create(((SecurityGroup.CreateBuilder)((SecurityGroup.CreateBuilder)SecurityGroup.CreateSecurityGroup.createBuilder().name(regionSecurityGroupNameAndPorts.getName())).description("security group created by jclouds")).build());
            return this.createSecurityGroupFrom(group, location, regionSecurityGroupNameAndPorts.getPorts());
        }
        Optional<org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi> api = this.novaApi.getSecurityGroupApi(regionId);
        Preconditions.checkArgument((boolean)api.isPresent(), (String)"Security groups are required, but the extension is not available in region %s!", (Object[])new Object[]{regionId});
        FluentIterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups = ((org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi)api.get()).list();
        this.logger.debug(">> creating securityGroup %s", new Object[]{regionSecurityGroupNameAndPorts});
        try {
            org.jclouds.openstack.nova.v2_0.domain.SecurityGroup novaSecurityGroup = ((org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi)api.get()).createWithDescription(regionSecurityGroupNameAndPorts.getName(), regionSecurityGroupNameAndPorts.getName());
            this.logger.debug("<< created securityGroup(%s)", new Object[]{novaSecurityGroup});
            for (int port : regionSecurityGroupNameAndPorts.getPorts()) {
                this.authorizeGroupToItselfAndAllIPsToTCPPort((org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi)api.get(), novaSecurityGroup, port);
            }
            return (SecurityGroup)this.securityGroupInRegionSecurityGroupFunction.apply((Object)new SecurityGroupInRegion(((org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi)api.get()).get(novaSecurityGroup.getId()), regionId, (Iterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup>)allGroups));
        }
        catch (IllegalStateException e) {
            this.logger.trace("<< trying to find securityGroup(%s): %s", new Object[]{regionSecurityGroupNameAndPorts, e.getMessage()});
            org.jclouds.openstack.nova.v2_0.domain.SecurityGroup group = (org.jclouds.openstack.nova.v2_0.domain.SecurityGroup)Iterables.find(allGroups, SecurityGroupPredicates.nameEquals(regionSecurityGroupNameAndPorts.getName()));
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{group.getId()});
            return (SecurityGroup)this.securityGroupInRegionSecurityGroupFunction.apply((Object)new SecurityGroupInRegion(group, regionId, (Iterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup>)allGroups));
        }
    }

    private SecurityGroup createSecurityGroupFrom(final org.jclouds.openstack.neutron.v2.domain.SecurityGroup group, Location location, Set<Integer> ports) {
        SecurityGroup securityGroup = this.neutronSecurityGroupToSecurityGroup.create(location).apply(group);
        this.logger.debug("<< created securityGroup(%s)", new Object[]{securityGroup});
        SecurityGroupApi securityGroupApi = this.getNeutronSecurityGroupApi(location.getId());
        try {
            for (int inboundPort : ports) {
                this.logger.debug(">> authorizing securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, inboundPort});
                securityGroupApi.create(((Rule.CreateBuilder)((Rule.CreateBuilder)((Rule.CreateBuilder)((Rule.CreateBuilder)Rule.CreateRule.createBuilder((RuleDirection)RuleDirection.INGRESS, (String)RegionAndId.fromSlashEncoded(securityGroup.getId()).getId()).protocol(RuleProtocol.TCP)).portRangeMin(Integer.valueOf(inboundPort))).portRangeMax(Integer.valueOf(inboundPort))).remoteIpPrefix("0.0.0.0/0")).build());
                this.logger.debug("<< authorized securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, inboundPort});
            }
            return securityGroup;
        }
        catch (IllegalStateException e) {
            this.logger.trace("<< trying to find securityGroup(%s): %s", new Object[]{group, e.getMessage()});
            return (SecurityGroup)securityGroupApi.listSecurityGroups().concat().filter((Predicate)new Predicate<org.jclouds.openstack.neutron.v2.domain.SecurityGroup>(){

                public boolean apply(@Nullable org.jclouds.openstack.neutron.v2.domain.SecurityGroup input) {
                    return input.getName().equals(group.getName());
                }
            }).transform((Function)this.neutronSecurityGroupToSecurityGroup.create(location)).first().orNull();
        }
    }

    private SecurityGroupApi getNeutronSecurityGroupApi(String region) {
        if (this.neutronContextSupplier == null) {
            return null;
        }
        return ((NeutronApi)((ApiContext)((Context)this.neutronContextSupplier.get())).getApi()).getSecurityGroupApi(region);
    }

    private void authorizeGroupToItselfAndAllIPsToTCPPort(org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi securityGroupApi, org.jclouds.openstack.nova.v2_0.domain.SecurityGroup securityGroup, int port) {
        this.logger.debug(">> authorizing securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, port});
        securityGroupApi.createRuleAllowingCidrBlock(securityGroup.getId(), ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(IpProtocol.TCP)).fromPort(port)).toPort(port)).build(), "0.0.0.0/0");
        this.logger.debug("<< authorized securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, port});
    }
}

