/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.rest.filter.BrooklynSecurityProviderFilterHelper;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=100)
public class BrooklynSecurityProviderFilterJersey
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(BrooklynSecurityProviderFilterJersey.class);
    @Context
    HttpServletRequest webRequest;
    @Context
    private ContextResolver<ManagementContext> mgmtC;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        log.trace("BrooklynSecurityProviderFilterJersey.filter {}", (Object)requestContext);
        try {
            new BrooklynSecurityProviderFilterHelper().run(this.webRequest, (ManagementContext)this.mgmtC.getContext(ManagementContext.class));
        }
        catch (SecurityProvider.SecurityProviderDeniedAuthentication e) {
            Response rin = e.getResponse();
            if (rin == null) {
                rin = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (rin.getStatus() == Response.Status.FOUND.getStatusCode()) {
                String location = rin.getHeaderString(HttpHeader.LOCATION.asString());
                if (location != null) {
                    log.trace("Redirect to {} for authentication", (Object)location);
                    UriBuilder uriBuilder = UriBuilder.fromPath((String)location);
                    rin = Response.temporaryRedirect((URI)uriBuilder.build(new Object[0])).entity((Object)("Authentication is required at " + location)).build();
                } else {
                    log.trace("Unauthorized");
                    rin = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication is required").build();
                }
            }
            requestContext.abortWith(rin);
        }
    }
}

