/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;

public class CompilerOptions {
    private File outputLocation;
    private String packageName = null;
    private boolean generateAll = false;
    private boolean offStrictValidation = false;
    private boolean isUseWrapperClasses = false;
    private String mapperClassPackage = null;
    private boolean helperMode = false;
    private Map<String, String> ns2PackageMap = new HashMap<String, String>();
    private boolean writeOutput = false;
    private boolean wrapClasses = false;
    private boolean backwordCompatibilityMode = false;
    private boolean suppressPrefixesMode = false;
    private boolean isIgnoreUnexpected;

    public String getMapperClassPackage() {
        return this.mapperClassPackage;
    }

    public void setMapperClassPackage(String mapperClassPackage) {
        this.mapperClassPackage = mapperClassPackage;
    }

    public boolean isMapperClassPackagePresent() {
        return this.mapperClassPackage != null && !"".equals(this.mapperClassPackage);
    }

    public boolean isHelperMode() {
        return this.helperMode;
    }

    public void setHelperMode(boolean helperMode) {
        this.helperMode = helperMode;
    }

    public Map<String, String> getNs2PackageMap() {
        return this.ns2PackageMap;
    }

    public void setNs2PackageMap(Map<String, String> ns2PackageMap) {
        this.ns2PackageMap = ns2PackageMap;
    }

    public boolean isWriteOutput() {
        return this.writeOutput;
    }

    public void setWriteOutput(boolean writeOutput) {
        this.writeOutput = writeOutput;
    }

    public boolean isWrapClasses() {
        return this.wrapClasses;
    }

    public void setWrapClasses(boolean wrapClasses) {
        this.wrapClasses = wrapClasses;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public CompilerOptions setPackageName(String packageName) {
        if (packageName == null || !this.testValue(packageName)) {
            throw new RuntimeException(SchemaCompilerMessages.getMessage("schema.unsupportedvalue"));
        }
        this.packageName = packageName;
        return this;
    }

    public File getOutputLocation() {
        return this.outputLocation;
    }

    public CompilerOptions setOutputLocation(File outputLocation) {
        this.outputLocation = outputLocation;
        return this;
    }

    private boolean testValue(String wordToMatch) {
        Pattern pat = Pattern.compile("^(\\w+\\.)+$");
        Matcher m = pat.matcher(wordToMatch);
        return m.matches();
    }

    public boolean isGenerateAll() {
        return this.generateAll;
    }

    public void setGenerateAll(boolean generateAll) {
        this.generateAll = generateAll;
    }

    public boolean isBackwordCompatibilityMode() {
        return this.backwordCompatibilityMode;
    }

    public void setBackwordCompatibilityMode(boolean backwordCompatibilityMode) {
        this.backwordCompatibilityMode = backwordCompatibilityMode;
    }

    public boolean isSuppressPrefixesMode() {
        return this.suppressPrefixesMode;
    }

    public void setSuppressPrefixesMode(boolean suppressPrefixesMode) {
        this.suppressPrefixesMode = suppressPrefixesMode;
    }

    public boolean isOffStrictValidation() {
        return this.offStrictValidation;
    }

    public void setOffStrictValidation(boolean offStrictValidation) {
        this.offStrictValidation = offStrictValidation;
    }

    public boolean isUseWrapperClasses() {
        return this.isUseWrapperClasses;
    }

    public void setUseWrapperClasses(boolean useWrapperClasses) {
        this.isUseWrapperClasses = useWrapperClasses;
    }

    public boolean isIgnoreUnexpected() {
        return this.isIgnoreUnexpected;
    }

    public void setIgnoreUnexpected(boolean isIgnoreUnexpected) {
        this.isIgnoreUnexpected = isIgnoreUnexpected;
    }
}

