/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.javax.tools;

import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;

class FileManagerUtils {
    private FileManagerUtils() {
    }

    static Iterable<Path> asPaths(final Iterable<? extends File> iterable) {
        return () -> new Iterator<Path>(){
            Iterator iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return ((File)this.iter.next()).toPath();
            }
        };
    }

    static Iterable<File> asFiles(final Iterable<? extends Path> iterable) {
        return () -> new Iterator<File>(){
            Iterator iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                Path path = (Path)this.iter.next();
                try {
                    return path.toFile();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw new IllegalArgumentException(path.toString(), unsupportedOperationException);
                }
            }
        };
    }
}

