/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.codegen.eclipse.ui;

import java.io.File;
import org.apache.axis2.tool.codegen.eclipse.plugin.CodegenWizardPlugin;
import org.apache.axis2.tool.codegen.eclipse.ui.AbstractWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class OutputPage
extends AbstractWizardPage {
    private static final String EMPTY_STRING = "";
    private static final int ECLIPSE_PROJECT_NAME_SEGMENT_INDEX = 0;
    private Text outputLocation;
    private Text axisHomeLocation;
    private Text jarFileNameText;
    private Button browseButton;
    private Button axisHomeBrowseButton;
    private Button axisLoadLibsButton;
    private Button copyLibButton;
    private Button jarCreationButton;
    private Button workspaceProjectOptionsButton;
    private Button filesyStemOptionsButton;
    private Button copyPluginLibButton;
    private boolean workspaceSaveOption = false;
    private boolean jarFileCopyOption = false;
    private Label axisHomeLabel;
    private Label axisLoadLibResultsLabel;
    private Label jarFileNameLabel;
    private String axis2LibsLocation = null;
    private Label hintLabel;
    private Button hintButton;
    private boolean hintVisible = false;
    private IProject selectedWorkspaceProject;

    public OutputPage() {
        super("page3");
    }

    @Override
    protected void initializeDefaultSettings() {
        this.settings.put("PREF_OUTPUT_LOCATION", EMPTY_STRING);
        this.settings.put("PREF_OUTPUT_LOCATION", EMPTY_STRING);
        this.settings.put("PREF_OUTPUT_LOCATION", EMPTY_STRING);
        this.settings.put("PREF_CHECK_WORKSPACE", false);
        this.settings.put("PREF_CHECK_FILE_SYSTEM", true);
        this.settings.put("PREF_CHECK_FILE_SYSTEM", false);
        this.settings.put("PREF_CHECK_FILE_SYSTEM", false);
        this.settings.put("PREF_CHECK_AXIS_PLUGIN_LIB_COPY", false);
        this.workspaceSaveOption = false;
        this.jarFileCopyOption = false;
        this.selectedWorkspaceProject = null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label selectLabel = new Label(container, 0);
        selectLabel.setText(CodegenWizardPlugin.getResourceString("page3.result.decs"));
        selectLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.workspaceProjectOptionsButton = new Button(container, 16);
        this.workspaceProjectOptionsButton.setLayoutData((Object)gd);
        this.workspaceProjectOptionsButton.setText(CodegenWizardPlugin.getResourceString("page3.workspace.caption"));
        this.workspaceProjectOptionsButton.setToolTipText(CodegenWizardPlugin.getResourceString("page3.workspace.desc"));
        this.settings.put("PREF_CHECK_WORKSPACE", false);
        this.settings.put("PREF_CHECK_FILE_SYSTEM", true);
        this.workspaceProjectOptionsButton.setSelection(this.settings.getBoolean("PREF_CHECK_WORKSPACE"));
        this.workspaceProjectOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handleCheckboxSelection();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.filesyStemOptionsButton = new Button(container, 16);
        this.filesyStemOptionsButton.setLayoutData((Object)gd);
        this.filesyStemOptionsButton.setText(CodegenWizardPlugin.getResourceString("page3.filesystem.caption"));
        this.filesyStemOptionsButton.setToolTipText(CodegenWizardPlugin.getResourceString("page3.filesystem.desc"));
        this.filesyStemOptionsButton.setSelection(this.settings.getBoolean("PREF_CHECK_FILE_SYSTEM"));
        this.filesyStemOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handleCheckboxSelection();
            }
        });
        gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText(CodegenWizardPlugin.getResourceString("page3.output.caption"));
        this.settings.put("PREF_OUTPUT_LOCATION", EMPTY_STRING);
        this.settings.put("PREF_OUTPUT_LOCATION", EMPTY_STRING);
        this.outputLocation = new Text(container, 2048);
        this.outputLocation.setText(this.settings.get("PREF_OUTPUT_LOCATION"));
        this.outputLocation.setLayoutData((Object)gd);
        this.outputLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OutputPage.this.settings.put("PREF_OUTPUT_LOCATION", OutputPage.this.outputLocation.getText());
                OutputPage.this.handleModifyEvent();
            }
        });
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(CodegenWizardPlugin.getResourceString("page3.outselection.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handleBrowse();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.copyPluginLibButton = new Button(container, 32);
        this.copyPluginLibButton.setText(CodegenWizardPlugin.getResourceString("page3.copypluginlib.caption"));
        this.copyPluginLibButton.setToolTipText(CodegenWizardPlugin.getResourceString("page3.copypluginlib.caption"));
        this.settings.put("PREF_CHECK_AXIS_PLUGIN_LIB_COPY", false);
        this.copyPluginLibButton.setSelection(this.settings.getBoolean("PREF_CHECK_AXIS_PLUGIN_LIB_COPY"));
        this.copyPluginLibButton.setLayoutData((Object)gd);
        this.copyPluginLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handleCopyPluginLibsCheckBox();
                OutputPage.this.settings.put("PREF_CHECK_AXIS_PLUGIN_LIB_COPY", OutputPage.this.copyPluginLibButton.getSelection());
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label fillLabel = new Label(container, 0);
        fillLabel.setText(EMPTY_STRING);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label fillLabel1 = new Label(container, 258);
        fillLabel1.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.copyLibButton = new Button(container, 32);
        this.copyLibButton.setText(CodegenWizardPlugin.getResourceString("page3.addaxislib.caption"));
        this.copyLibButton.setToolTipText(CodegenWizardPlugin.getResourceString("page3.addaxislib.desc"));
        this.settings.put("PREF_CHECK_FILE_SYSTEM", false);
        this.copyLibButton.setSelection(this.settings.getBoolean("PREF_CHECK_FILE_SYSTEM"));
        this.copyLibButton.setLayoutData((Object)gd);
        this.copyLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handlejarCheckBox();
                OutputPage.this.settings.put("PREF_CHECK_FILE_SYSTEM", OutputPage.this.copyLibButton.getSelection());
            }
        });
        gd = new GridData(768);
        this.axisHomeLabel = new Label(container, 0);
        this.axisHomeLabel.setText(CodegenWizardPlugin.getResourceString("page3.axishome.caption"));
        this.axisHomeLocation = new Text(container, 2048);
        this.axisHomeLocation.setLayoutData((Object)gd);
        this.settings.put("PREF_OUTPUT_LOCATION", EMPTY_STRING);
        this.axisHomeLocation.setText(this.settings.get("PREF_OUTPUT_LOCATION"));
        this.axisHomeLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OutputPage.this.settings.put("PREF_OUTPUT_LOCATION", OutputPage.this.axisHomeLocation.getText());
                OutputPage.this.handleAxisHomeModifyEvent();
            }
        });
        this.axisHomeBrowseButton = new Button(container, 8);
        this.axisHomeBrowseButton.setText(CodegenWizardPlugin.getResourceString("page3.outselection.browse"));
        this.axisHomeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handleAxisHomeBrowse();
            }
        });
        this.axisLoadLibsButton = new Button(container, 8);
        this.axisLoadLibsButton.setText(CodegenWizardPlugin.getResourceString("page3.loadlibs.browse"));
        this.axisLoadLibsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handleLoadLibsBrowse();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd = new GridData(768);
        this.axisLoadLibResultsLabel = new Label(container, 0);
        this.axisLoadLibResultsLabel.setText(EMPTY_STRING);
        this.axisLoadLibResultsLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label fillLabel2 = new Label(container, 258);
        fillLabel2.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.jarCreationButton = new Button(container, 32);
        this.jarCreationButton.setText(CodegenWizardPlugin.getResourceString("page3.jarcreation.caption"));
        this.jarCreationButton.setToolTipText(CodegenWizardPlugin.getResourceString("page3.jarcreation.desc"));
        this.settings.put("PREF_CHECK_FILE_SYSTEM", false);
        this.jarCreationButton.setSelection(this.settings.getBoolean("PREF_CHECK_FILE_SYSTEM"));
        this.jarCreationButton.setLayoutData((Object)gd);
        this.jarCreationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handlejarCreationCheckBox();
            }
        });
        gd = new GridData(768);
        this.jarFileNameLabel = new Label(container, 0);
        this.jarFileNameLabel.setText(CodegenWizardPlugin.getResourceString("page3.jarname.caption"));
        this.jarFileNameText = new Text(container, 2048);
        this.jarFileNameText.setLayoutData((Object)gd);
        this.jarFileNameText.setText(this.settings.get("PREF_OUTPUT_LOCATION"));
        this.jarFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OutputPage.this.settings.put("PREF_OUTPUT_LOCATION", OutputPage.this.jarFileNameText.getText());
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label fillLabel3 = new Label(container, 258);
        fillLabel3.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.hintButton = new Button(container, 8);
        this.hintButton.setText(CodegenWizardPlugin.getResourceString("page3.hint.off"));
        this.hintButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPage.this.handleHintBrowse();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.hintLabel = new Label(container, 0);
        this.hintLabel.setText(CodegenWizardPlugin.getResourceString("page3.hint.caption"));
        this.hintLabel.setLayoutData((Object)gd);
        this.hintLabel.setVisible(this.hintVisible);
        this.disableControls();
        this.setControl((Control)container);
        if (this.restoredFromPreviousSettings) {
            this.handleModifyEvent();
        }
    }

    private void handleHintBrowse() {
        if (this.hintVisible) {
            this.hintButton.setText(CodegenWizardPlugin.getResourceString("page3.hint.off"));
            this.hintVisible = false;
            this.hintLabel.setVisible(this.hintVisible);
        } else {
            this.hintButton.setText(CodegenWizardPlugin.getResourceString("page3.hint.on"));
            this.hintVisible = true;
            this.hintLabel.setVisible(this.hintVisible);
        }
    }

    public String getOutputLocation() {
        return this.outputLocation.getText();
    }

    public String getAxisHomeLocation() {
        return this.axisHomeLocation.getText();
    }

    public String getJarFilename() {
        return this.jarFileNameText.getText();
    }

    public boolean getAxis2PluginLibCopyCheckBoxSelection() {
        return this.copyPluginLibButton.getSelection();
    }

    public boolean getAxisLibCopyCheckBoxSelection() {
        return this.copyLibButton.getSelection();
    }

    public boolean getCreateJarCheckBoxSelection() {
        return this.jarCreationButton.getSelection();
    }

    public String getAxisJarsLocation() {
        return this.axis2LibsLocation;
    }

    public boolean oktoLoadLibs() {
        return this.jarFileCopyOption;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileNameText.setText(jarFileName);
    }

    private void handleModifyEvent() {
        String text = this.outputLocation.getText();
        if (text == null || text.trim().equals(EMPTY_STRING)) {
            this.updateStatus(CodegenWizardPlugin.getResourceString("page3.error.nolocation"));
            return;
        }
        this.updateStatus(null);
    }

    private void handleAxisHomeModifyEvent() {
        String text = this.axisHomeLocation.getText();
        if (text == null || text.trim().equals(EMPTY_STRING)) {
            this.updateStatus(CodegenWizardPlugin.getResourceString("page3.error.nolocation"));
            return;
        }
        this.updateStatus(null);
    }

    private void handleCheckboxSelection() {
        if (this.workspaceProjectOptionsButton.getSelection()) {
            this.settings.put("PREF_CHECK_WORKSPACE", true);
            this.settings.put("PREF_CHECK_FILE_SYSTEM", false);
            this.workspaceSaveOption = true;
        } else if (this.filesyStemOptionsButton.getSelection()) {
            this.settings.put("PREF_CHECK_FILE_SYSTEM", true);
            this.settings.put("PREF_CHECK_WORKSPACE", false);
            this.workspaceSaveOption = false;
        }
    }

    private void handlejarCheckBox() {
        if (this.copyLibButton.getSelection()) {
            this.enableControls();
            this.settings.put("PREF_CHECK_FILE_SYSTEM", true);
        } else {
            this.disableControls();
            this.settings.put("PREF_CHECK_FILE_SYSTEM", false);
        }
    }

    private void handleCopyPluginLibsCheckBox() {
        if (this.copyPluginLibButton.getSelection()) {
            this.settings.put("PREF_CHECK_AXIS_PLUGIN_LIB_COPY", true);
        } else {
            this.settings.put("PREF_CHECK_AXIS_PLUGIN_LIB_COPY", false);
        }
    }

    private void handlejarCreationCheckBox() {
        if (this.jarCreationButton.getSelection()) {
            this.settings.put("PREF_CHECK_FILE_SYSTEM", true);
        } else {
            this.settings.put("PREF_CHECK_FILE_SYSTEM", false);
            this.jarFileNameText.setText(EMPTY_STRING);
        }
        if (EMPTY_STRING.equals(this.jarFileNameLabel.getText())) {
            this.updateStatus("Please enter a valid name to the jar file");
        }
    }

    private void disableControls() {
        this.axisHomeLocation.setText("Unpacked Axis2 binary home Or Axis2 source location");
        this.axisHomeBrowseButton.setEnabled(false);
        this.axisHomeLocation.setEnabled(false);
        this.jarCreationButton.setSelection(false);
        this.jarCreationButton.setEnabled(false);
        this.axisHomeLabel.setEnabled(false);
        this.axisLoadLibResultsLabel.setText(EMPTY_STRING);
        this.axisLoadLibResultsLabel.setEnabled(false);
        this.axisLoadLibsButton.setEnabled(false);
        this.jarFileNameLabel.setEnabled(false);
        this.jarFileNameText.setText(EMPTY_STRING);
        this.jarFileNameText.setEnabled(false);
        this.settings.put("PREF_CHECK_FILE_SYSTEM", false);
        this.jarFileCopyOption = false;
        Color color = this.getShell().getDisplay().getSystemColor(29);
        this.axisLoadLibResultsLabel.setBackground(color);
    }

    private void enableControls() {
        this.axisHomeBrowseButton.setEnabled(true);
        this.axisHomeLocation.setEnabled(true);
        this.jarCreationButton.setEnabled(true);
        this.axisHomeLabel.setEnabled(true);
        this.axisLoadLibResultsLabel.setEnabled(true);
        this.axisLoadLibsButton.setEnabled(true);
        this.jarFileNameLabel.setEnabled(true);
        this.jarFileNameText.setEnabled(true);
        if (this.axisLoadLibResultsLabel.getText().equals(EMPTY_STRING)) {
            this.updateStatus("Please enter a valid path to the Axis2 libs and then try to load the libraries using the check libs button");
        }
        this.axisLoadLibResultsLabel.setText(CodegenWizardPlugin.getResourceString("page3.loadlib.fail.caption"));
        Color color = this.getShell().getDisplay().getSystemColor(3);
        this.axisLoadLibResultsLabel.setBackground(color);
    }

    private void handleAxisHomeBrowse() {
        this.axisHomeLocation.setText("unpacked Axis2 binary home Or Axis2 source Location");
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String returnString = dialog.open();
        if (returnString != null) {
            this.axisHomeLocation.setText(returnString);
            this.settings.put("PREF_OUTPUT_LOCATION", this.axisHomeLocation.getText());
        }
    }

    private void handleLoadLibsBrowse() {
        if (this.axisHomeLocation.getText().equals(EMPTY_STRING)) {
            this.axisLoadLibResultsLabel.setText(CodegenWizardPlugin.getResourceString("page3.loadlib.fail.caption"));
            this.jarFileCopyOption = false;
            if (this.axisLoadLibResultsLabel.getText().equals(EMPTY_STRING)) {
                this.updateStatus("Please enter a valid path to the Axis2 libs and then try to load the libraries using the check libs button");
            }
        } else {
            this.settings.put("PREF_OUTPUT_LOCATION", this.axisHomeLocation.getText());
            String axis_home = this.settings.get("PREF_OUTPUT_LOCATION");
            String axis_target_lib = axis_home + File.separator + "target" + File.separator + "lib";
            String axis_std_lib_directory = axis_home + File.separator + "lib";
            File axis_target_libs_directory = new File(axis_target_lib);
            File axis_libs_directory = new File(axis_std_lib_directory);
            if (axis_libs_directory.isDirectory() || axis_target_libs_directory.isDirectory()) {
                this.axisLoadLibResultsLabel.setText(CodegenWizardPlugin.getResourceString("page3.loadlib.success.caption"));
                if (axis_libs_directory.isDirectory()) {
                    this.axis2LibsLocation = axis_std_lib_directory;
                } else if (axis_target_libs_directory.isDirectory()) {
                    this.axis2LibsLocation = axis_target_lib;
                }
                this.jarFileCopyOption = true;
                Color color = this.getShell().getDisplay().getSystemColor(29);
                this.axisLoadLibResultsLabel.setBackground(color);
            } else {
                this.axisLoadLibResultsLabel.setText(CodegenWizardPlugin.getResourceString("page3.loadlib.fail.caption"));
                Color color = this.getShell().getDisplay().getSystemColor(3);
                this.axisLoadLibResultsLabel.setBackground(color);
                this.updateStatus(CodegenWizardPlugin.getResourceString("page3.loadlib.fail.message"));
                this.jarFileCopyOption = false;
            }
        }
    }

    private void handleBrowse() {
        boolean location = false;
        if (this.settings.getBoolean("PREF_CHECK_FILE_SYSTEM")) {
            location = false;
        } else if (this.settings.getBoolean("PREF_CHECK_WORKSPACE")) {
            location = true;
        }
        if (this.workspaceSaveOption) {
            location = true;
        }
        if (!location) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            String returnString = dialog.open();
            if (returnString != null) {
                this.outputLocation.setText(returnString);
            }
        } else {
            Path path;
            Object[] result;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)root, false, CodegenWizardPlugin.getResourceString("page3.containerbox.title"));
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && root.exists((IPath)(path = (Path)result[0]))) {
                IProject project = null;
                StringBuilder builder = new StringBuilder();
                if (path.segmentCount() > 1) {
                    project = root.getProject(path.segment(0));
                    for (int i = 1; i < path.segments().length; ++i) {
                        builder.append(File.separator).append(path.segment(i));
                    }
                } else {
                    project = root.getProject(path.toOSString());
                }
                if (project != null) {
                    this.outputLocation.setText(project.getLocation().toOSString() + builder.toString());
                    this.selectedWorkspaceProject = project;
                } else {
                    this.outputLocation.setText(root.getLocation().append((IPath)path).toFile().getAbsolutePath());
                }
            }
        }
    }

    @Override
    public int getPageType() {
        return 1;
    }

    public IProject getSelectedWorkspaceProject() {
        if (this.workspaceSaveOption) {
            return this.selectedWorkspaceProject;
        }
        return null;
    }
}

