/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd1;

import com.jthink.brainz.mmd.Artist;
import com.jthink.brainz.mmd.Metadata;
import com.jthink.brainz.mmd.ObjectFactory;
import com.jthink.brainz.mmd.ReleaseGroup;
import com.jthink.brainz.mmd.ReleaseGroupList;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.musicbrainz.mmd2.ArtistCredit;
import org.musicbrainz.mmd2.NameCredit;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.helper.ArtistCreditHelper;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.ReleaseGroupIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd1.Mmd1XmlWriter;

public class ReleaseGroupMmd1XmlWriter
extends Mmd1XmlWriter {
    public Metadata write(Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        Metadata metadata = of.createMetadata();
        ReleaseGroupList releaseGroupList = of.createReleaseGroupList();
        for (Result result : results.results) {
            ArtistCredit ac;
            String type;
            MbDocument doc = result.getDoc();
            ReleaseGroup releaseGroup = of.createReleaseGroup();
            releaseGroup.setId(doc.get((IndexField)ReleaseGroupIndexField.RELEASEGROUP_ID));
            result.setNormalizedScore(results.getMaxScore());
            releaseGroup.getOtherAttributes().put(this.getScore(), String.valueOf(result.getNormalizedScore()));
            String name = doc.get((IndexField)ReleaseGroupIndexField.RELEASEGROUP);
            if (name != null) {
                releaseGroup.setTitle(name);
            }
            if (this.isNotUnknown(type = doc.get((IndexField)ReleaseGroupIndexField.TYPE))) {
                releaseGroup.getType().add(StringUtils.capitalize((String)type));
            }
            if (doc.get((IndexField)ReleaseGroupIndexField.ARTIST_CREDIT) != null && (ac = ArtistCreditHelper.unserialize((String)doc.get((IndexField)ReleaseGroupIndexField.ARTIST_CREDIT))).getNameCredit().size() > 0) {
                Artist artist = of.createArtist();
                artist.setName(((NameCredit)ac.getNameCredit().get(0)).getArtist().getName());
                artist.setId(((NameCredit)ac.getNameCredit().get(0)).getArtist().getId());
                artist.setSortName(((NameCredit)ac.getNameCredit().get(0)).getArtist().getSortName());
                releaseGroup.setArtist(artist);
            }
            releaseGroupList.getReleaseGroup().add(releaseGroup);
        }
        releaseGroupList.setCount(BigInteger.valueOf(results.getTotalHits()));
        releaseGroupList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setReleaseGroupList(releaseGroupList);
        return metadata;
    }
}

