# `ftpdir-cleanup`/`db-cleanup`/`sourceballs`

The README says:

> When we remove a package from a repository, it stays in the package
> "pool".  We would like to be able to eventually remove packages from
> the pool, to reclaim the disk space:
>
>  - `cron-jobs/ftpdir-cleanup`
>  - `cron-jobs/db-cleanup`
>
> Both of these programs do the exact same thing.  Parabola developers
> decided to write their own from scratch, instead of modifying
> `ftpdir-cleanup`.  They should eventually be merged.

There are 2 big differences between `ftpdir-cleanup` and `db-cleanup`:

 1. `ftpdir-cleanup` needs to be run once per PKGPOOL (via differing
    `DBSCRIPTS_CONFIG` environment variables), `db-cleanup` runs just
    once, and recieves a complete list of PKGPOOLs via
    `db-cleanup.conf`.
 2. `db-cleanup` cleans source packages; `ftpdir-cleanup` delegates
    that to the separate `sourceballs` program.

Since Parabola doesn't use the `sourceballs` program to *create*
source packages, I'mnot sure it makes sense to use it to *remove*
them.

# `db-import`

`db-import` should use `db-move`, `db-remove`, and `db-update`
internally.

Blockers:

 - `db-move` and `db-remove` are broken.  NOT ANY MORE, THEY WORK NOW!

# Test suite

Setting up an environment that can run the test suite is rather
odious.  Arch uses Docker to make that easier; the Dockerfile sets up
everything in the container, and it doesn't need to "infect" the host
system.  We should do that too.

Blockers:

 - There isn't a good Docker base image of Parabola.
