/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo.CountElementVo;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;

public class CountVo {
    private ICompilationUnit cu;
    private String name;
    private int javadocLines;
    private int totalJavadocLines;
    private int methodsJavadocLines;
    private List methods = new ArrayList();
    private int fieldsJavadocLines;
    private int fieldNum;
    private List fields = new ArrayList();

    public CountVo(ICompilationUnit compUnit) {
        this.cu = compUnit;
        this.name = compUnit.getResource().getLocation().toOSString();
    }

    public void addMethod(CountElementVo element) {
        this.methods.add(element);
        this.methodsJavadocLines += element.getJavadocLine();
    }

    public void addField(CountElementVo element) {
        this.fields.add(element);
        this.fieldsJavadocLines += element.getJavadocLine();
        this.fieldNum += element.getNum();
    }

    public void setJavadocLines(int javadocLines) {
        this.javadocLines = javadocLines;
    }

    public void setTotalJavadocLines(int totalJavadocLines) {
        this.totalJavadocLines = totalJavadocLines;
    }

    public double getMethodAverage() {
        if (this.methods.size() == 0) {
            return 0.0;
        }
        return (double)this.methodsJavadocLines / (double)this.methods.size();
    }

    public double getFieldAverage() {
        if (this.fields.size() == 0) {
            return 0.0;
        }
        return (double)this.fieldsJavadocLines / (double)this.fieldNum;
    }

    public IFile getFile() {
        return (IFile)this.cu.getResource();
    }

    public int getTotalJavadocLines() {
        return this.totalJavadocLines;
    }

    public int getFieldNum() {
        return this.fieldNum;
    }

    public List getFields() {
        return this.fields;
    }

    public int getFieldsJavadocLines() {
        return this.fieldsJavadocLines;
    }

    public int getJavadocLines() {
        return this.javadocLines;
    }

    public List getMethods() {
        return this.methods;
    }

    public int getMethodsJavadocLines() {
        return this.methodsJavadocLines;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append(this.name);
        sb.append("\r\n");
        sb.append("  javadocLines:");
        sb.append(this.javadocLines);
        sb.append("\r\n");
        sb.append("  totalJavadocLines:");
        sb.append(this.totalJavadocLines);
        sb.append("\r\n");
        sb.append("  method average:");
        sb.append(this.getMethodAverage());
        sb.append("\r\n");
        sb.append("  method:");
        sb.append("\r\n");
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            CountElementVo method = (CountElementVo)iter.next();
            sb.append("    ");
            sb.append(method.getName());
            sb.append(" - javadocLines:");
            sb.append(method.getJavadocLine());
            sb.append("\r\n");
        }
        sb.append("  field average:");
        sb.append(this.getFieldAverage());
        sb.append("\r\n");
        sb.append("  field:");
        sb.append("\r\n");
        iter = this.fields.iterator();
        while (iter.hasNext()) {
            CountElementVo field = (CountElementVo)iter.next();
            sb.append("    ");
            sb.append(field.getName());
            sb.append(" - javadocLines:");
            sb.append(field.getJavadocLine());
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

