/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.csvutil;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ykhr.csvutil.CSVElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final Comparator<CSVElement> PRIORITY_COMP = new Comparator<CSVElement>(){

        @Override
        public int compare(CSVElement o1, CSVElement o2) {
            if (o1.priority() < o2.priority()) {
                return -1;
            }
            if (o1.priority() > o2.priority()) {
                return 1;
            }
            return this.compareStr(o1.name(), o2.name());
        }

        private int compareStr(String o1, String o2) {
            boolean o2IsNUll;
            boolean o1IsNull = o1 == null;
            boolean bl = o2IsNUll = o2 == null;
            if (o1IsNull && o2IsNUll) {
                return 0;
            }
            if (o1IsNull) {
                return 1;
            }
            if (o2IsNUll) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    };

    public static Map<CSVElement, PropertyDescriptor> createCsvToPropertyInfo(Class<?> clazz) throws IntrospectionException {
        HashMap<CSVElement, PropertyDescriptor> result = new HashMap<CSVElement, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propDescs.length; ++i) {
            CSVElement csvAnnotation;
            String name = propDescs[i].getName();
            Field field = Utils.getPropertyField(clazz, name);
            if (field == null || (csvAnnotation = field.getAnnotation(CSVElement.class)) == null) continue;
            result.put(csvAnnotation, propDescs[i]);
        }
        return result;
    }

    public static Map<String, PropertyDescriptor> createCsvNameToProperty(Class<?> clazz) throws IntrospectionException {
        Map<CSVElement, PropertyDescriptor> map = Utils.createCsvToPropertyInfo(clazz);
        HashMap<String, PropertyDescriptor> result = new HashMap<String, PropertyDescriptor>();
        for (Map.Entry<CSVElement, PropertyDescriptor> entry : map.entrySet()) {
            result.put(entry.getKey().name(), entry.getValue());
        }
        return result;
    }

    private static Field getPropertyField(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(name);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return Utils.getPropertyField(clazz.getSuperclass(), name);
        }
    }
}

