/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.csvutil;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import jp.gr.java_conf.ykhr.csvutil.config.ReadConfig;
import jp.gr.java_conf.ykhr.csvutil.converter.Converter;
import jp.gr.java_conf.ykhr.csvutil.converter.HeaderBaseConverter;
import jp.gr.java_conf.ykhr.csvutil.escaper.DefaultEscaper;
import jp.gr.java_conf.ykhr.csvutil.escaper.Unescaper;
import jp.gr.java_conf.ykhr.csvutil.ex.CSVReadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReader {
    private static final Unescaper DEFAULT_UNESCAPER = new DefaultEscaper();
    private static final Converter DEFAULT_CONVERTER = new HeaderBaseConverter();
    private Unescaper unescaper;
    private Converter converter;

    public CSVReader() {
        this(DEFAULT_UNESCAPER, DEFAULT_CONVERTER);
    }

    public CSVReader(Unescaper unescaper) {
        this(unescaper, DEFAULT_CONVERTER);
    }

    public CSVReader(Converter unescaper) {
        this(DEFAULT_UNESCAPER, unescaper);
    }

    public CSVReader(Unescaper unescaper, Converter converter) {
        this.unescaper = unescaper;
        this.converter = converter;
    }

    public <T> Collection<T> read(File file, Class<T> clazz) throws CSVReadException {
        return this.read(file, clazz, new ReadConfig());
    }

    public <T> Collection<T> read(File file, Class<T> clazz, ReadConfig config) throws CSVReadException {
        String contents = this.readFile(file, config.getEncoding());
        Collection<String[]> elements = this.divideItem(contents, config);
        Collection<T> result = this.convert(elements, clazz, config);
        return result;
    }

    private <T> Collection<T> convert(Collection<String[]> elements, Class<T> clazz, ReadConfig config) throws CSVReadException {
        Collection<T> result = this.converter.toBeanCollection(clazz, elements, config);
        return result;
    }

    private Collection<String[]> divideItem(String contents, ReadConfig config) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        boolean inItem = false;
        ArrayList<String> items = new ArrayList<String>();
        StringBuilder item = new StringBuilder();
        for (int i = 0; i < contents.length(); ++i) {
            char c = contents.charAt(i);
            if (inItem && this.unescaper.isEscapingValue(contents, i)) {
                item.append(this.unescaper.unescape(contents, i));
                i += this.unescaper.skipLengthAfterUnescape();
                continue;
            }
            if (!inItem && this.equalsString(contents, i, config.getSeparator())) {
                items.add(item.toString());
                item.setLength(0);
                i += config.getSeparator().length() - 1;
                continue;
            }
            if (!inItem && this.equalsString(contents, i, config.getLineEnding())) {
                items.add(item.toString());
                item.setLength(0);
                result.add(items.toArray(new String[items.size()]));
                items.clear();
                i += config.getLineEnding().length() - 1;
                continue;
            }
            if (!inItem && c == ' ') continue;
            if (this.equalsString(contents, i, config.getQuoteString())) {
                inItem = !inItem;
                continue;
            }
            item.append(contents.charAt(i));
        }
        items.add(item.toString());
        if (items.size() == ((String[])result.get(0)).length) {
            result.add(items.toArray(new String[items.size()]));
        }
        return result;
    }

    private boolean equalsString(String contents, int index, String check) {
        if (contents.length() < index + check.length()) {
            return false;
        }
        String value = contents.substring(index, index + check.length());
        return value.equals(check);
    }

    private String readFile(File file, String encoding) throws CSVReadException {
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] b = new byte[1024];
            int read = 0;
            while ((read = input.read(b)) != -1) {
                out.write(b, 0, read);
            }
            String string = out.toString(encoding);
            return string;
        }
        catch (IOException e) {
            throw new CSVReadException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

