<?php
// 
// WHLX CMS - new.php 
// 
// 20040403 - 0.00 alpha
// 20040411 - 0.04 alpha    外部ファイルの整理. ディレクトリ類は 'path.ini', へ移動. 設定類は 'whlx.ini' へ移動. 
// 20040413 - 0.05 alpha    文字列変換( '><' -> ">\r\n<" )の順番を修正. 
// 20040413 - 0.06 alpha    whlx.ini の仕様変更に伴う少々の変更. 
// 




error_reporting( E_ERROR | E_PARSE );


$error   =  1;
$message =  'FAILED    : 新規投稿に失敗しました. ';
$others  =  '';


// './path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// './path.ini' はスクリプトと同じディレクトリに置く必要があります. 
$whlx =  parse_ini_file( './path.ini',      true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 


$result =  WHLX_New_Article    ( $error, $message, $others, $whlx           );
$output =  WHLX_PostingResponse( $error, $message, $others, './_script.xsl' );


WHLX_ResponseHeader_XML ();
echo  $output;


exit;








// WHLX_New_Article( $error, $message, $others );
function  WHLX_New_Article( &$error, &$message, &$others, $whlx )
{
	$formdata =  new WHLX_Formdata();              // 
	$header   =  $formdata->header();              // 
	$form     =  $formdata->form  ();              // 
	$data     =  array_merge( $form, $header );    // 
	$output   =  array();                          // 
	$result   =  false;                            // 

	$data[ 'pw_crypt'     ] =  $whlx[ 'owner' ][ 'password' ];
//	$data[ 'creator'      ] =  'WHLX';    
	$data[ 'category'     ] =  '0001';    
//	$data[ 'ping'         ] =  '';    
	$data[ 'art_filedata' ] =  '';
	$data[ 'cat_filedata' ] =  '';
	$data[ 'new_filedata' ] =  '';

	$data[ 'form_attribute' ][ 'action'  ] =  $whlx[ 'script' ][ 'new_article' ];
	$data[ 'form_attribute' ][ 'method'  ] =  'post';
	$data[ 'form_attribute' ][ 'accept'  ] =  'text/plain';
	$data[ 'form_attribute' ][ 'charset' ] =  'UTF-8';
	$data[ 'form_attribute' ][ 'enctype' ] =  'application/x-www-form-urlencoded';
	$data[ 'form_attribute' ][ 'lang'    ] =  'ja';

	$data[ 'xslt'         ] =  './_default.xsl';                                                                          // 
	$data[ 'id'           ] =  '0001';                                                                                    // 新規投稿の記事なので, 必ず '0001' になります. 
	$data[ 'art_filename' ] =  $whlx[ 'directory' ][ 'data' ].  $whlx[ 'filename' ][ 'articles'   ];                      // 記事リストのファイル名を解決し, 記入します. 

	$others                 =  "\r\n";
	$others                 .= "\t\t".  "<title> WHLX CMS - 新規投稿スクリプト </title> ".  "\r\n";
	$others                 .= WHLX_New_Formdata               ( $data );                                                 // 
	$others                 .= WHLX_New_ResultPreview          ( $data );                                                 // 

	$result                 =  WHLX_New_DataChecker            ( $data, $error, $message );                               // フォーム・データが空でないかどうか, パスワードを間違えてないかどうか, 調べます. 
	if( true != $result ) return false;

	$result                 =  WHLX_New_DataConverter          ( $data );                                                 // 制限文字数に切り詰め, HTMLタグや改行コードを変換します. 
	if( true != $result ) return false;


	// 記事の通し番号文字列 'series' が不明のままでは生成できない文字列などを生成します. 
	// まず 'series' 文字列を生成しますが, 之の生成には記事リスト・ファイル名が必要です. 
	$data[ 'series'       ] =  WHLX_New_Number_In_ListArticles ( $data );                                                 // 現在の記事リストを読み込んで、次に加える記事の通し番号を生成します. 
	$data[ 'resource'     ] =  './art_'.  $data[ 'series'   ].  '.xml#0001';                                              // 記事リスト及びカテゴリ別・記事リストに於いて使われるハイパー・リンク先を文字列 'resource' に記入します. 
	$data[ 'url'          ] =  './art_'.  $data[ 'series'   ].  '.xml#0001';                                              // 新規投稿された記事に於いて使われるハイパー・リンク先を文字列 'url' に記入します. 
	$data[ 'art_filename' ] =  $whlx[ 'directory' ][ 'data' ].  $whlx[ 'filename' ][ 'articles'   ];                      // 記事リストのファイル名を解決し, 記入します. しかしながら, この操作は既に解決済みであり, プログラムを読み易くする為だけに挿入された行です. 
	$data[ 'cat_filename' ] =  $whlx[ 'directory' ][ 'data' ].  './cat_'.  $data[ 'category' ].  '.xml';                  // カテゴリ別・記事リストのファイル名を解決し, 記入します. 
	$data[ 'new_filename' ] =  $whlx[ 'directory' ][ 'data' ].  './art_'.  $data[ 'series'   ].  '.xml';                  // 新規投稿された記事のファイル名を解決し, 記入します. 

	$data[ 'trackback'    ] =  $whlx[ 'directory_url' ][ 'script' ];
	$data[ 'trackback'    ] .= $whlx[ 'script' ][ 'trackback' ];
	$data[ 'trackback'    ] .= '/'.  $data[ 'series' ].  '/';                                                             // 記事に対するPing受け入れURLを文字列 'trackback' に記入します. 

	$data[ 'art_filedata' ] =  WHLX_New_InsertItem_ArticlesList( $data );                                                 // 記事アイテムを追加する事を以って, 記事リスト・データを再生成します. 
	$data[ 'cat_filedata' ] =  WHLX_New_InsertItem_CategoryList( $data );                                                 // 記事アイテムを追加する事を以って, カテゴリ別・記事リスト・データを再生成します. 
	$data[ 'new_filedata' ] =  WHLX_New_Create_NewArticle      ( $data );                                                 // 新規投稿された記事データを新規生成します. 

	$result                 =  WHLX_FileOutput( $data[ 'new_filedata' ], $data[ 'new_filename' ], WHLX_XML_FILEMODE );    // 
	if( true != $result ) return false;

	$result                 =  WHLX_FileOutput( $data[ 'art_filedata' ], $data[ 'art_filename' ], WHLX_XML_FILEMODE );    // 
	if( true != $result ) return false;

	$result                 =  WHLX_FileOutput( $data[ 'cat_filedata' ], $data[ 'cat_filename' ], WHLX_XML_FILEMODE );    // 
	if( true != $result ) return false;

	return true;
}




// WHLX_New_DataChecker( $output, $_error, $message );
// // フォームに入力されたデータが空でないかどうか, パスワードを間違えてないかどうか, 調べます. 
function  WHLX_New_DataChecker( &$data, &$error, &$message )
{
	$error   =  0;
	$message =  '';

	if( $data[ 'title'    ] == ''                                         ){ $error |= 1;  $message .= "\t\tERROR     : 表題       が未入力です. <br /> \n"; }
	if( $data[ 'text'     ] == ''                                         ){ $error |= 1;  $message .= "\t\tERROR     : 本文       が未入力です. <br /> \n"; }
	if( $data[ 'creator'  ] == ''                                         ){ $error |= 1;  $message .= "\t\tERROR     : 筆者名     が未入力です. <br /> \n"; }
	if( !WHLX_PasswordChecker( $data[ 'password' ], $data[ 'pw_crypt' ] ) ){ $error |= 1;  $message .= "\t\tERROR     : パスワード が違います.   <br /> \n"; }
	if( $error == 0 ){ $message .= "\r\n\t\tSUCCEEDED : 書き込みに成功しました.  <br /> \r\n";  return true;  }
	else             { $message .= "\r\n\t\tFAILED    : 書き込みに失敗しました.  <br /> \r\n";  return false; }
}




// WHLX_New_DataConverter( $data );
// // HTMLタグや改行コードを変換します. 
// // 文字数を制限します. 
function  WHLX_New_DataConverter( &$data )
{
	// 'function WHLX_DateTimeString' は './utility.php' の中で記述されている補助関数です. 
	// 'function WHLX_ConvertString'  は './utility.php' の中で記述されている補助関数です. 
	$data[ 'date'        ] =  WHLX_DateTimeString();                                          
	$data[ 'title'       ] =  WHLX_ConvertString( $data[ 'title'   ], 0x007F,   128 );    
	$data[ 'text'        ] =  WHLX_ConvertString( $data[ 'text'    ], 0x007F,  4096 );    
	$data[ 'ping'        ] =  $data[ 'ping'     ];    
	$data[ 'creator'     ] =  WHLX_ConvertString( $data[ 'creator' ], 0x007F,   128 );    
	$data[ 'date'        ] =  WHLX_ConvertString( $data[ 'date'    ], 0x007F,   128 );    
	$data[ 'title_short' ] =  WHLX_ConvertString( $data[ 'title'   ], 0x007F,    16 );    
	$data[ 'category'    ] =  $data[ 'category' ];    
	$data[ 'pw_crypt'    ] =  $data[ 'pw_crypt' ];    
	return true;
}




// WHLX_New_PingCreate( $ping );
function  WHLX_New_PingCreate( $ping )
{
	$output =  '';
	$array  =  preg_split( "/[\s]+/", $ping, -1, PREG_SPLIT_NO_EMPTY );

	reset( $array );
	while( list( , $value ) = each( $array ) ) 
		$output .= '			<ping url="'.    $value.   '" /> '.    "\r\n";

	return $output;
}




// WHLX_New_Number_In_ListArticles ( $data );
// // 新規生成する記事ファイルの中に記入される記事番号を判定します. 
// // 記事リスト・ファイルのアイテム通し番号に +1 した物を新しい記事番号と決定します. 
// // 出力形式は文字列であり, フォーマットは %04d の形になります. 
function WHLX_New_Number_In_ListArticles ( $data )
{
	$dom    =  xmldocfile( $data[ 'art_filename' ] );    
	$whlx   =  $dom    ->child_nodes();
	$arts   =  $whlx[1]->child_nodes();
	$item   =  $arts[1]->child_nodes();
	$atts   =  $item[1]->attributes ();
	foreach( $atts as $att ) if( $att->name() == 'id' ) $id_last =  $att->value();
	$series =  substr( ( '1'.  $id_last ) + 1, 1, 4 );

	return  $series;
}




// WHLX_New_Create_NewArticle( $data );
// // 記事ファイルを新規生成します. 
function  WHLX_New_Create_NewArticle( $data )
{
	$dom       =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi        =  WHLX_DomXML_RegisterXSLT ( $dom, $data[ 'xslt' ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx      =  WHLX_DomXML_CreateChild  ( $dom, $dom       , 'whlx     '   , '' );    
	$items     =  WHLX_DomXML_CreateChild  ( $dom, $whlx      , 'items    '   , '' );    
	$item      =  WHLX_DomXML_CreateChild  ( $dom, $items     , 'item     '   , '' );    
	$title     =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'title    '   , '' );    
	$url       =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'url      '   , '' );    
	$text      =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'text     '   , '' );    
	$creator   =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'creator  '   , '' );    
	$date      =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'date     '   , '' );    
	$trackback =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'trackback'   , '' );    

	$whlx->set_attribute( 'series'  , $data[ 'series'      ] );    
	$whlx->set_attribute( 'category', $data[ 'category'    ] );    
	$whlx->set_attribute( 'title'   , $data[ 'title_short' ] );    
	$item->set_attribute( 'id'      , $data[ 'id'          ] );    

	WHLX_DomXML_CreateComment  ( $dom, $title    , ' WHLX_New_Create_NewArticle title     ' );    
	WHLX_DomXML_CreateComment  ( $dom, $url      , ' WHLX_New_Create_NewArticle url       ' );    
	WHLX_DomXML_CreateComment  ( $dom, $text     , ' WHLX_New_Create_NewArticle text      ' );    
	WHLX_DomXML_CreateComment  ( $dom, $creator  , ' WHLX_New_Create_NewArticle creator   ' );    
	WHLX_DomXML_CreateComment  ( $dom, $date     , ' WHLX_New_Create_NewArticle date      ' );    
	WHLX_DomXML_CreateComment  ( $dom, $trackback, ' WHLX_New_Create_NewArticle trackback ' );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '<!-- WHLX_New_Create_NewArticle title     -->', $data[ 'title'       ], $output );
	$output =  str_replace( '<!-- WHLX_New_Create_NewArticle url       -->', $data[ 'url'         ], $output );
	$output =  str_replace( '<!-- WHLX_New_Create_NewArticle text      -->', $data[ 'text'        ], $output );
	$output =  str_replace( '<!-- WHLX_New_Create_NewArticle creator   -->', $data[ 'creator'     ], $output );
	$output =  str_replace( '<!-- WHLX_New_Create_NewArticle date      -->', WHLX_DateTimeString() , $output );
	$output =  str_replace( '<!-- WHLX_New_Create_NewArticle trackback -->', $data[ 'trackback'   ], $output );
	$output =  str_replace( '><'                                           , ">\r\n<"              , $output );
	return  $output;
//	return  $dom->dumpmem();
}




// WHLX_New_InsertItem_ArticlesList( $data );
// // 記事アイテムを追加する事を以って, 記事リスト・ファイルを再生成します. 
function  WHLX_New_InsertItem_ArticlesList( $data )
{
	$dom  =  xmldocfile( $data[ 'art_filename' ] );    
	$whlx =  $dom    ->child_nodes();
	$list =  $whlx[1]->child_nodes();
	$item =  $dom->create_element( 'item' );
	$list[1]->insert_before( $item, $list[1]->first_child() );

	$item->set_attribute( 'id'      , $data[ 'series'      ] );    
	$item->set_attribute( 'resource', $data[ 'resource'    ] );    
	$item->set_attribute( 'title'   , $data[ 'title_short' ] );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><', ">\r\n<", $output );
	return  $output;
}




// WHLX_New_InsertItem_CategoryList( $data );
// // 記事アイテムを追加する事を以って, カテゴリ別・記事リスト・ファイルを再生成します. 
function  WHLX_New_InsertItem_CategoryList( $data )
{
	$dom  =  xmldocfile( $data[ 'cat_filename' ] );    
	$whlx =  $dom    ->child_nodes();
	$list =  $whlx[1]->child_nodes();
	$item =  $dom->create_element( 'item' );
	$list[1]->insert_before( $item, $list[1]->first_child() );

	$item->set_attribute( 'id'      , $data[ 'series'      ] );    
	$item->set_attribute( 'resource', $data[ 'resource'    ] );    
	$item->set_attribute( 'title'   , $data[ 'title_short' ] );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><', ">\r\n<", $output );
	return  $output;
}




// 
function  WHLX_New_Formdata( $data )
{
	if( $data[ 'style_br'  ] == 'true' ) $br =  'checked';    else $br =  '';    // 
	if( $data[ 'style_tg'  ] == 'true' ) $tg =  'checked';    else $tg =  '';    // 
//	$action =  WHLX_URI_NEW.  '?profile='.  $_form[ 'profile'   ];
	$action =  $data[ 'action' ];

	return 
		'		<form password="yes"> '.                                                              "\r\n".    
		'			<attribute> '.                                                                "\r\n".    
		'				<action >'.  $data[ 'form_attribute' ][ 'action'  ].  '</action > '.  "\r\n".    
		'				<method >'.  $data[ 'form_attribute' ][ 'method'  ].  '</method > '.  "\r\n".    
		'				<accept >'.  $data[ 'form_attribute' ][ 'accept'  ].  '</accept > '.  "\r\n".    
		'				<charset>'.  $data[ 'form_attribute' ][ 'charset' ].  '</charset> '.  "\r\n".    
		'				<enctype>'.  $data[ 'form_attribute' ][ 'enctype' ].  '</enctype> '.  "\r\n".    
		'				<lang   >'.  $data[ 'form_attribute' ][ 'lang'    ].  '</lang   > '.  "\r\n".    
		'			</attribute> '.                                                               "\r\n".    
		'			<title>'   .  $data[ 'title'     ].  '</title>    '.                          "\r\n".    
		'			<text>'    .  $data[ 'text'      ].  '</text>     '.                          "\r\n".    
//		'			<style_br>'.  $br                 .  '</style_br> '.                          "\r\n".    
//		'			<style_tg>'.  $tg                 .  '</style_tg> '.                          "\r\n".    
		'			<ping>'    .  $data[ 'ping'      ].  '</ping>     '.                          "\r\n".    
		'			<creator>' .  $data[ 'creator'   ].  '</creator>  '.                          "\r\n".    
		'			<category>'.  $data[ 'category'  ].  '</category> '.                          "\r\n".    
//		'			<profile>' .  $data[ 'profile'   ].  '</profile>  '.                          "\r\n".    
		'		</form> '.                                                                            "\r\n";    
}




// 
function  WHLX_New_ResultPreview( $data )
{
	return 
		'		<result>  <item>  '.                                              "\r\n".    
		'			<title    > '.   $data[ 'title'     ].  ' </title    >'.  "\r\n".    
		'			<url      > '.   $data[ 'url'       ].  ' </url      >'.  "\r\n".    
		'			<text     > '.   $data[ 'text'      ].  ' </text     >'.  "\r\n".    
		'			<creator  > '.   $data[ 'creator'   ].  ' </creator  >'.  "\r\n".    
		'			<date     > '.   $data[ 'date'      ].  ' </date     >'.  "\r\n".    
		'			<trackback> '.   $data[ 'trackback' ].  ' </trackback>'.  "\r\n".    
		'		</item> </result> '.                                              "\r\n";    
}




?>
