/* $Id: SmlElement.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 쐬F 2004/10/12
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package sml_editor.node;

import java.util.NoSuchElementException;
import java.util.Vector;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * @author kawamura
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class SmlElement extends SmlChildNode {
	
	private Element fElement;
	private Vector<SmlNode> fChildren = new Vector<SmlNode>();
	

	/**
	 * @param elem
	 */
	public SmlElement(Element elem) {
		fElement = elem;
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#getNode()
	 */
	public Node getNode() {
		return fElement;
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#appendChild(editor.node.SMLNode)
	 */
	public SmlNode appendChild(SmlNode newChild) {
		return insertBefore(newChild, null);
	}
	
	public SmlNode appendChild2(SmlNode newChild) {
		return insertBefore2(newChild, null);
	}
	
	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#insertBefore(editor.node.SMLNode)
	 */
	public SmlNode insertBefore(SmlNode newChild, SmlNode refChild) {
		SmlNode node = insertBefore2(newChild, refChild);
		if(refChild == null) {
			fElement.insertBefore(newChild.getNode(), null);
		} else {
			fElement.insertBefore(newChild.getNode(), refChild.getNode());
		}
		return node;
	}

	/**
	 * newChildrefChild̑OɒǉB̍ە̐ݒ͍sȂ
	 * @return
	 */
	public SmlNode insertBefore2(SmlNode newChild, SmlNode refChild) {
		if(refChild == null) {
			fChildren.add(newChild);
		} else {
			int index = fChildren.indexOf(refChild);
			fChildren.add(index, newChild);
		}
		newChild.setParentNode(this);
		plusLength(newChild.getLength());
		return newChild;
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#removeChild(editor.node.SMLNode)
	 */
	public SmlNode removeChild(SmlNode oldChild) {
		fChildren.remove(oldChild);
		fElement.removeChild(oldChild.getNode());
		plusLength(-1 * oldChild.getLength());
		return oldChild;
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#replaceChild(editor.node.SMLNode, editor.node.SMLNode)
	 */
	public SmlNode replaceChild(SmlNode newChild, SmlNode oldChild) {
		insertBefore(newChild, oldChild);
		removeChild(oldChild);
		return oldChild;
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#getFirstChild()
	 */
	public SmlNode getFirstChild() {
		try {
			return (SmlNode)fChildren.firstElement();
		} catch (NoSuchElementException e) {
			// qm[hƂnullԂ
			return null;
		}
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#getLastChild()
	 */
	public SmlNode getLastChild() {
		try {
			return (SmlNode)fChildren.lastElement();
		} catch (NoSuchElementException e) {
			// qm[hƂnullԂ
			return null;
		}
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#hasAttributes()
	 */
	public boolean hasAttributes() {
		return fElement.hasAttributes();
	}

	/* childNode Ԗڂ̎q𒲂ׂ */
	protected int indexOf(SmlNode childNode) {
		return fChildren.indexOf(childNode);
	}

	protected SmlNode getChild(int index) {
		try {
			return (SmlNode)fChildren.get(index);
		} catch(ArrayIndexOutOfBoundsException e) {
			return null;
		}
	}
	
	/* (Javadoc Ȃ)
	 * @see editor.node.SMLChildNode#caluculateLength()
	 */
	protected int calculateLength() {
		int sum = 0;
		for(int i = 0; i < fChildren.size(); i++) {
			sum += ((SmlNode)fChildren.get(i)).getLength();
		}
		return sum;
	}
	
	/**
	 * ݒ肷
	 * @param increment - 
	 */
	void plusLength(int increment) {
		int length = fLength + increment;
		if(fParent != null) {
			fLength = length;
			fParent.plusLength(increment);
		} else {
			fLength = length;
		}
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#getNodeType()
	 */
	public short getNodeType() {
		return SmlNode.ELEMENT_NODE;
	}

	/**
	 * @return ^O
	 */
	public String getTagName() {
		return fElement.getTagName();
	}
}
