/* $Id: BmpFileCreator.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

import smart_gs.logical.Spread;
/**
 * 
 * @author kazuaki kobayashi
 *
 *  spread̉摜񂩂bmpt@C쐬
 */
public class BmpFileCreator {
	
	private Image image;
	private int width;
	private int height;
	
	private static final String BMP = "bmp";
	/**
	 * 
	 * @param spread
	 */
	public BmpFileCreator(Spread spread){
		ImageIcon imageIcon = spread.getImageIcon();
		this.width = imageIcon.getIconWidth();
		this.height = imageIcon.getIconHeight();
		this.image = imageIcon.getImage();
		
	}
	public BmpFileCreator(Image image,int width,int height){
		this.image = image;
		this.width = width;
		this.height = height;
	}
	public void create(String folderPath,String filename,boolean showMessage){
		try {
			File file = new File(folderPath+filename);
			if(file.exists()){
				if(showMessage){
//					{overwrite邩̊mFKv
				}
				
				file.delete();
			}
			BufferedImage bufImage = new BufferedImage(this.width,this.height,BufferedImage.TYPE_INT_RGB);
			Graphics offg = bufImage.getGraphics();
			offg.drawImage(this.image,0,0,this.width,this.height,null);
			ImageIO.write(bufImage,BmpFileCreator.BMP,new File(folderPath+filename));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
