package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import smart_gs.image_search.logical.TextType;
import smart_gs.logical.GSResource;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.swingui.action.SetRWBackgroundAction.ImageFileFilter;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.InConstruction;
import smart_gs.util.SegfoToLineConverter;

public class ReadSegmentInfoAction implements ActionListener {
	private String file_contents;
	private LineSegEditor editor;
	private Spread spread;
	private String file_name;
	private List<LineSegmentForEdit> lines = null;
	private JFileChooser chooser;
	
	public ReadSegmentInfoAction(LineSegEditor parent) {
		this.editor = parent;
		this.spread = this.editor.getSpread();
		this.file_name = this.spread.getFileName();
		this.chooser = new JFileChooser(Preference.getInstance().getImageFolderPathString() + spread.getFolderPath());
	}
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
		chooser.setMultiSelectionEnabled(false);
		chooser.setFileFilter(new SegfoFileFilter());
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		
		int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
		if (input == JFileChooser.CANCEL_OPTION) {
			return;
		}
		
		File file = chooser.getSelectedFile();
		
		lines = new SegfoToLineConverter(spread).getLinesForEdit(file);
        editor.setLinesForEdit(lines);
        editor.rewriteLineSegIndexes();
        editor.repaint();
	}
}

