/* $Id: ReasoningWebFrame.java 428 2011-10-17 00:45:55Z minao $ */
/*
 * 쐬: 2006/06/02
 *
 */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.reasoning_web.logical.GS_RWRepository;

/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")

public class ReasoningWebFrame extends JFrame {
	
	private static ReasoningWebFrame singleton = new ReasoningWebFrame();
		
	private ConnectonViewPanel connectonViewPanel;
	private DesktopPanel desktopPanel;
	public static final int CONNECTION_VIEW = 0;
	public static final int DESKTOP_VIEW = 1;
	private int mode = CONNECTION_VIEW;

	
	private ReasoningWebFrame(){
		super("Reasoning Web Connection View");
		this.connectonViewPanel = new ConnectonViewPanel();
		this.desktopPanel = new DesktopPanel();	
		this.getContentPane().setLayout(new BorderLayout());
		this.setJMenuBar(new RWMenubar());
		this.getContentPane().add(this.connectonViewPanel.getToolBar(),BorderLayout.NORTH);
		this.getContentPane().add(this.connectonViewPanel,BorderLayout.CENTER);		
		this.setSize(900,700);
	}
	
	public void setMainPanel(FolderPanel panel){
		this.desktopPanel.setMainPanel(panel);
	}
	
	//view mode̐؂ւilink view-desktop viewj
	public void setMode(int mode){
		this.mode = mode;
		if(this.mode == CONNECTION_VIEW){
			this.setTitle("Reasoning Web Connection View");
			this.getJMenuBar().setVisible(true);
			this.getContentPane().remove(this.desktopPanel);
			this.getContentPane().remove(this.desktopPanel.getToolBar());
			this.getContentPane().add(this.connectonViewPanel,BorderLayout.CENTER);
			this.getContentPane().add(this.connectonViewPanel.getToolBar(),BorderLayout.NORTH);
		}else if(this.mode == DESKTOP_VIEW){
			this.setTitle("Reasoning Web Desktop View");
			this.getJMenuBar().setVisible(false);
			this.getContentPane().remove(this.connectonViewPanel);
			this.getContentPane().remove(this.connectonViewPanel.getToolBar());
			this.getContentPane().add(this.desktopPanel,BorderLayout.CENTER);
			this.getContentPane().add(this.desktopPanel.getToolBar(),BorderLayout.NORTH);
		}
		validate();
		repaint();
	}
	
	//UtilityPanelĂяo郁\bh
	public static ReasoningWebFrame getInstance(){
		return singleton;
	}
	
	//DesctopPanelĂяo
	public void up(){
		if(this.mode == DESKTOP_VIEW){
				this.desktopPanel.up();
		}
	}
	public void upWithSelectedElements() {
		if(this.mode == DESKTOP_VIEW){
			Object[] elements = this.desktopPanel.getSelectedElements();
			if (elements == null) {
				this.desktopPanel.up();
			} else {
				this.desktopPanel.upWithSelectedElements(elements);
			}
		}
	}
	
	public DesktopPanel getDesktopPanel() {
		return desktopPanel;
	}
	
	public void reload(){
		connectonViewPanel.reload();
		desktopPanel.updateAll();
		validate();
		repaint();
	}
	
	public void initializeContentsAndFrame(){
		//these two initialize the contents
		GS_RWRepository.getInstance().initialize();
		ReasoningWebDesktop.getInstance().initialize();
		//this one initializes desktop panel
		desktopPanel.initialize();
		this.reload();
		validate();
		repaint();
	}
	
	public DeskTopFolder getCurrentFolder() {
		return this.desktopPanel.getCurrentFolder();
	}
	public ElementsPanel getElementsPanel() {
		return this.connectonViewPanel.getElementsPanel();
	}
	
}
