/* $Id: ExplanatoryNoteDialog.java 320 2011-08-25 14:13:37Z shayashi $ */
/*
 * 쐬: 2006/06/04
 *
 */
package smart_gs.reasoning_web;

import java.awt.BorderLayout;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

import smart_gs.connection.ExplanatoryPanel;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.WorkspaceWindow;

/**
 * @author kazuaki kobayashi
 * 
 * 
 */
@SuppressWarnings("serial")
public class ExplanatoryNoteDialog extends JDialog {

	private ExplanatoryPanel panel;
	private GSExplanatoryNote note;
	private boolean isCanceled = false;

	public ExplanatoryNoteDialog(GSExplanatoryNote note) {
		// super(new JFrame("Explanatory Note"));
		// Lł͂
		// I[i[t[͕Kew肵ȂƁAJ[\ςȂ
		super(WorkspaceWindow.getInstance());
		this.setModal(true);
		this.panel = new ExplanatoryPanel(this, note);
		this.build();
		this.note = note;
		//2007/11/20 kazuhiro kobayashi
		if(note.getName()!=""){
			this.setTitle("Explanatory Note: "+note.getName());
		}
		//
		this.setSize(600,500);
		
	}

	private void build() {
		this.getContentPane().removeAll();
		this.setTitle("Explanatory Note");
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(this.panel, BorderLayout.CENTER);
		this.setSize(400, 200);
	}

	public JPanel getLocalViewPanel() {
		// 2007/11/2 kazuhiro kobayashi
		// ExplanatoryPanel panel = new ExplanatoryPanel(null, this.note);
		this.panel.getTextPane().getGSHTMLEditorTextPane().setEditable(true);
		return panel.getTextPanel();
	}

	// 2007/11/2 kazuhiro kobayashi
	public GSEditorTextPane getTextPane() {
		this.panel = new ExplanatoryPanel(null, this.note);
		return panel.getTextPane();
	}

	public void setIsCanceled(boolean isCanceled) {
		this.isCanceled = isCanceled;
	}

	public boolean isCanceled() {
		return isCanceled;
	}
}
