/* $Id: IDAT.java 312 2011-08-21 07:57:51Z shayashi $ */
package smart_gs.logical;


import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import smart_gs.GSConstants;
import smart_gs.logical.visitor.Visitor;
import sml_editor.parser.SMLParser;


public abstract class IDAT extends SmartDocument{
	
	protected Spread spread;

//	2011.02.24 shayashi
	protected String nameToDisplay = null;
	
	public String getNameToDisplay() {
		return nameToDisplay;
	}
	public void setNameToDisplay(String nameToDisplay) {
		this.nameToDisplay = nameToDisplay;
	}
	
	public IDAT(String uri, String originalURI, String version){
		super();
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}
	public IDAT(Spread spread, String uri, String originalURI, String version) {
		super();
		this.spread = spread;	
		this.source = "<xml><html></html></xml>";
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}

	//	2011/05/20 kukita
	public IDAT(Spread spread) {
		super();
		this.spread = spread;	
		this.source = "<xml><html></html></xml>";
		this.setURIs();
	}
	public Spread getSpread(){
		return this.spread;
	}
	@Override
	public String getSource() {
		return this.source;
	}

	public void setSource(String source){
		this.source = source;
	}

	public abstract int getType();
	

	public GSResource getTextSegmentByURI(String uri) {
		for(int i=0;i<this.segments.size();i++){
			if(this.segments.get(i).getURI().equals(uri)){
				return this.segments.get(i);
			}
		}
		return null;
	}
	public void setSpread(Spread spread) {
		this.spread = spread;
		this.confirmSegments();
	}
	private void confirmSegments(){
		Document doc;
		try {
			doc = SMLParser.parse(this.source);
			this.checkSegments(doc.getDocumentElement());
		} catch (SAXException e) {
			e.printStackTrace();
		}
	}
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	public abstract String getExtension();
	
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	public int getIDATIndex() {
		if (this instanceof FirstIDAT) {
			return 1;
		}
		if (this instanceof SecondIDAT) {
			return 2;
		}
		if (this instanceof ThirdIDAT) {
			return 3;
		}
//		error case
		return -1;
	}
}
