/* $Id: SearchResultPanelContextMode.java 574 2012-09-12 15:25:48Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import smart_gs.image_search.ContextImageCropper;
import smart_gs.image_search.logical.SearchResult;

@SuppressWarnings("serial")

class SearchResultPanelContextMode extends SearchResultPanelOfLineMode{
		
	// 20110423 Image arg is not likely used in this mode. The null arg will work.
	SearchResultPanelContextMode(SearchResultViewer parent,List<SearchResult> results,Image queryImage){
		super(parent,results,queryImage);
		
	}	
	protected JLabel createImageLabel(SearchResult result){	
		ContextImageCropper cropper = new ContextImageCropper(result);
		BufferedImage bufImage = (BufferedImage)cropper.crop();	
		ImageIcon icon = new ImageIcon(bufImage);	
		JLabel label = new JLabel();
		label.setIcon(icon);
		label.addMouseListener(new LabelMouseListener(label,result.getSpread(),result.getRectangle()));
		return label;
	}
}