/* $Id: ResultPopupWindow.java 574 2012-09-12 15:25:48Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.TitledBorder;

import smart_gs.image_search.LineImageCropper;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;

@SuppressWarnings("serial")
public class ResultPopupWindow extends JWindow{
	
	public ResultPopupWindow(SearchResult result) {
		super();
		LineImageCropper cropper = new LineImageCropper(result);
		Image image = cropper.crop();
		image = cropper.fillRelative((BufferedImage)image);
		JLabel label = new JLabel(new ImageIcon(image));
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add(label,BorderLayout.CENTER);
		if (TextType.isHorizontal()) panel.setBorder(new TitledBorder(result.getSpread().getURI()));
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(panel,BorderLayout.CENTER);
	}
}
