/* $Id: RightClickMenu.java 521 2012-07-12 16:49:07Z shayashi $ */
package smart_gs.drawing_tool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

import smart_gs.connection.ConnectionCreator;
import smart_gs.dictionary.DictionaryRegisterDialog;
import smart_gs.drawing_tool.action.AddToBasketAction;
import smart_gs.drawing_tool.action.AnchorJumpToLinkedTextActionListener;
import smart_gs.drawing_tool.action.BookmarkSizeAction;
import smart_gs.drawing_tool.action.ChangeBreadthAction;
import smart_gs.drawing_tool.action.ChangeColorAction;
import smart_gs.drawing_tool.action.ChangeRegionTitleAction;
import smart_gs.drawing_tool.action.CloseUpViewerAction;
import smart_gs.drawing_tool.action.CreateShortCutAction;
import smart_gs.drawing_tool.action.DeleteArrowAction;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.action.MemoPadTextAction;
import smart_gs.drawing_tool.action.NextRegionAction;
import smart_gs.drawing_tool.action.ProtectRegionAction;
import smart_gs.drawing_tool.action.ReleaseProtectedRegionAction;
import smart_gs.drawing_tool.action.SetLinkSourceAction;
import smart_gs.drawing_tool.action.SetLinkTargetAction;
import smart_gs.drawing_tool.action.DrawArrowAction;
import smart_gs.drawing_tool.action.cancelConnectionCreationAction;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.TextSegment;
import smart_gs.logical.region.AnchorRegion;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.logical.visitor.ShowResourceVisitor;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;

@SuppressWarnings("serial")
public class RightClickMenu extends JPopupMenu{	
	
	public RightClickMenu(final Region region, SpreadCanvas canvas, final State state, boolean temporary) {
		String title = region.getView().getTitle();
		JMenuItem displayTitle = new JMenuItem("Title: " + title);
		displayTitle.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				new ChangeRegionTitleAction(region).execute();
			}
		});
		this.add(displayTitle);
		this.addSeparator();
		

		JMenuItem delete = new JMenuItem("Delete Markup");
		delete.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				new DeleteRegionAction(region, state).execute();
			}
		});
		this.add(delete);
		if (!temporary) {
			this.addSeparator();

			JMenuItem setSource = new JMenuItem("Set Link Source");
			if((!ConnectionCreator.isMakingLink()) ||
					ConnectionCreator.isMakingLinkTargetAlreadySet()){
				setSource.setEnabled(true);
				setSource.addActionListener(new SetLinkSourceAction(region));
			}else{
				setSource.setEnabled(false);
			}
			this.add(setSource);

			JMenuItem setTarget = new JMenuItem("Set Link Target");
			if((!ConnectionCreator.isMakingLink()) ||
					ConnectionCreator.isMakingLinkSourceAlreadySet()){
				setTarget.setEnabled(true);
				setTarget.addActionListener(new SetLinkTargetAction(region));
			}else{
				setTarget.setEnabled(false);
			}
			this.add(setTarget);

			JMenuItem cancelConnectionCreation = new JMenuItem("Cancel Connection Creation");
			cancelConnectionCreation.addActionListener(new cancelConnectionCreationAction());
			if(ConnectionCreator.isMakingLink()) {
				cancelConnectionCreation.setEnabled(true);
			} else {
				cancelConnectionCreation.setEnabled(false);
			}
			this.add(cancelConnectionCreation);

			JMenuItem jump = new JMenuItem("Show Local View");
			if(!GS_RWRepository.getInstance().hasLink(region) || ConnectionCreator.isMakingLink()){
				jump.setEnabled(false);
			}
			jump.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent arg0) {
					new ShowLocalViewAction(region).execute();
				}
			});
			this.add(jump);

			if (region.getView().getType() == View.ANCHOR) {
				JMenuItem jumpToText = new JMenuItem("Jump to Linked Text");
				jumpToText.addActionListener(new AnchorJumpToLinkedTextActionListener((AnchorRegion)region));
				this.add(jumpToText);
			}

			JMenuItem createShortcut = new JMenuItem("Create Short Cut");
			createShortcut.addActionListener(new CreateShortCutAction(region));
			//20080622 shimizu wrote
			//this.add(createShortcut);

			//this.addSeparator();

			/*
			 *@kazuhiro kobayashi
			 */
		}
		this.addSeparator();

		if (region.isProtected().equals(Region.NORMAL)){
			JMenuItem protectRegion = new JMenuItem("Protect Markup");
			protectRegion.addActionListener(new ProtectRegionAction(region));
			this.add(protectRegion);
		} else {
			JMenuItem releaseProtectedRegion = new JMenuItem("Release Protected Markup");
			releaseProtectedRegion.addActionListener(new ReleaseProtectedRegionAction(region));
			this.add(releaseProtectedRegion);
		}

		/**
		 *
		 */
		JMenuItem registDic = new JMenuItem("Register in the dictionary");
		registDic.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				DictionaryRegisterDialog dialog = new DictionaryRegisterDialog(WorkspaceWindow.getInstance(), "Register" , true,region);
				dialog.setVisible(true);
			}
		});
		this.add(registDic);

		//	2011.01.11 shayashi added
		JMenuItem closeup = new JMenuItem("Close-up");
		if(!(region.getView().getType() == View.RECTANGLE ||
				region.getView().getType() == View.POLYGON)){
			closeup.setEnabled(false);
		}
		closeup.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				new CloseUpViewerAction(region);
			}
		});
		this.add(closeup);

		if (region.getView().getType() == View.MEMOPAD || 
				region.getView().getType() == View.MARKER) {
			
			this.addSeparator();
			JMenu changeColor = new JMenu("Color");
			JMenuItem yellow = new JMenuItem("Yellow");
			yellow.addActionListener(new ChangeColorAction(region, View.ViewColor.YELLOW));
			changeColor.add(yellow);

			JMenuItem cyan = new JMenuItem("Cyan");
			cyan.addActionListener(new ChangeColorAction(region, View.ViewColor.CYAN));
			changeColor.add(cyan);
			
			JMenuItem magenta = new JMenuItem("Magenta");
			magenta.addActionListener(new ChangeColorAction(region, View.ViewColor.MAGENTA));
			changeColor.add(magenta);

			JMenuItem green = new JMenuItem("Green");
			green.addActionListener(new ChangeColorAction(region, View.ViewColor.GREEN));
			changeColor.add(green);
			
			if (region.getView().getType() == View.MEMOPAD) {
				changeColor.addSeparator();
	
				JMenuItem transparent = new JMenuItem("Transparent");
				transparent.addActionListener(new ChangeColorAction(region, View.ViewColor.TRANSPARENT));
				JMenuItem opaque = new JMenuItem("Opaque");
				opaque.addActionListener(new ChangeColorAction(region, View.ViewColor.OPAQUE));
				
				if (((MemoPadView)region.getView()).isTransparent()) {
					changeColor.add(opaque);
				} else {
					changeColor.add(transparent);
				}
			}
			this.add(changeColor);
			if (region.getView().getType() == View.MEMOPAD) {

				JMenuItem addText = new JMenuItem("Add Text");
				addText.addActionListener(new MemoPadTextAction(region));
				this.add(addText);
				
				JMenuItem drawArrow = new JMenuItem("Draw Arrow");
				drawArrow.addActionListener(new DrawArrowAction(region, canvas));
				this.add(drawArrow);
	
				if (((MemoPadView)region.getView()).getArrows().size() != 0) {
					JMenuItem deleteArrow = new JMenuItem("Delete Arrow");
					deleteArrow.addActionListener(new DeleteArrowAction(region, canvas));
					this.add(deleteArrow);
				}
			}
			if (region.getView().getType() == View.MARKER) {
				JMenuItem changeBreadth = new JMenuItem("Breadth");
				changeBreadth.addActionListener(new ChangeBreadthAction(canvas, region));
				this.add(changeBreadth);
			}

		}
		if (region.getView().getType() == View.BOOKMARK) {
			BookmarkRegion bookmark = (BookmarkRegion)region;
			BookmarkView view = (BookmarkView)region.getView();
			JMenu changeSize = new JMenu("Size");
			JMenuItem  huge = new JRadioButtonMenuItem((int)(100 * BookmarkView.HUGE) + "%", view.getSize() == BookmarkView.HUGE);
			JMenuItem large = new JRadioButtonMenuItem((int)(100 * BookmarkView.LARGE) + "%", view.getSize() == BookmarkView.LARGE);
			JMenuItem normal = new JRadioButtonMenuItem((int)(100 * BookmarkView.NORMAL) + "%", view.getSize() == BookmarkView.NORMAL);
			JMenuItem small = new JRadioButtonMenuItem((int)(100 * BookmarkView.SMALL) + "%", view.getSize() == BookmarkView.SMALL);
			JMenuItem tiny = new JRadioButtonMenuItem((int)(100 * BookmarkView.TINY) + "%", view.getSize() == BookmarkView.TINY);
			huge.addActionListener(new BookmarkSizeAction(bookmark,BookmarkView.HUGE));
			large.addActionListener(new BookmarkSizeAction(bookmark,BookmarkView.LARGE));
			normal.addActionListener(new BookmarkSizeAction(bookmark,BookmarkView.NORMAL));
			small.addActionListener(new BookmarkSizeAction(bookmark,BookmarkView.SMALL));
			tiny.addActionListener(new BookmarkSizeAction(bookmark,BookmarkView.TINY));
			changeSize.add(huge);
			changeSize.add(large);
			changeSize.add(normal);
			changeSize.add(small);
			changeSize.add(tiny);
			this.add(changeSize);
		}

		View view = region.getView();
		JMenuItem nextRegion = new JMenuItem("Select Next" +" "+ view.getTypeStringForDisplay());
		nextRegion.addActionListener(new NextRegionAction(region, canvas, state));
		this.add(nextRegion);
		
		JMenu bucket = new JMenu("Add to Basket");
		List<GSResource> baskets = GS_RWRepository.getInstance().getResourceBaskets();
		for (int i = 0; i < baskets.size(); i++) {
			JMenuItem item = new JMenuItem(baskets.get(i).getName());
			item.addActionListener(new AddToBasketAction((ResourceBasket) baskets.get(i), region));
			bucket.add(item);
		}
		this.add(bucket);
		JMenuItem basketFrame = new JMenuItem("Send to Basket List");
		basketFrame.addActionListener(new AddToBasketAction(region));
		this.add(basketFrame);
	}
	
}
