/* $Id: ResourcePointer.java 454 2011-10-26 14:22:00Z minao $ */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.GSResource;
import smart_gs.logical.URISolver;
import smart_gs.logical.Zombie;

/**
 * 
 * @author kazuaki kobayashi
 * 
 *
 */
public class ResourcePointer {
	public static final int OUT = 0;
	public static final int IN = 1;
	public static final int BOTH = 2;

	//regiontagelement
	protected RWElement rw_element;
	//2007/10/23 kazuhiro kobayashi
//	protected ExplanatoryNote expNote;
	protected String name = "";
	
	protected List<ResourcePointer> targets;
	protected List<ResourcePointer> sources;
	protected List<Connection> connections;


	private boolean isSource = true;
		
	/**
	 * @return the isSource
	 */
	public boolean isSource() {
		return isSource;
	}
	/**
	 * @param isSource the isSource to set
	 */
	public void setSource(boolean isSource) {
		this.isSource = isSource;
	}
	protected ResourcePointer(RWElement element){
		this.rw_element = element;
		this.connections = new ArrayList<Connection>();
		this.targets = new ArrayList<ResourcePointer>();
		this.sources = new ArrayList<ResourcePointer>();
	}
	public List<ResourcePointer> getForwardLinkElements(){
		return this.targets;
	}
	public List<ResourcePointer> getBackLinkElements(){
		return this.sources;
	}
	public List<Connection> getConnections(){
		return this.connections;
	}
	
	public List<RWElement> getDirectLinkElements(){
		List<RWElement> elements = new ArrayList<RWElement>();
		for(int i=0;i<this.targets.size();i++){
			elements.add(this.targets.get(i).getRwElement());
		}
		for(int i=0;i<this.sources.size();i++){
			elements.add(this.sources.get(i).getRwElement());
		}
		return elements;
	}

	void addConnection(Connection connection){
		this.connections.add(connection);
	}

	public void addTarget(ResourcePointer target){
		this.targets.add(target);
	}
	
	public void addSource(ResourcePointer source){
		this.sources.add(source);
	}
	
	public RWElement getRwElement(){
		return this.rw_element;
	}
	
	public void setRwElement(RWElement rwElement) {
		rw_element = rwElement;
	}
	public boolean hasLink() {
		if(this.connections.size() <= 0){
			return false;
		}
		return true;
	}
	public boolean hasTarget() {
		if (this.targets.size() <= 0) {
			return false;
		}
		return true;
	}
	public boolean hasSource() {
		if (this.sources.size() <= 0) {
			return false;
		}
		return true;
	}
	
	public String getSource() throws NotMarkupException {
		throw new NotMarkupException();
	}
	
	//2007/10/23 kazuhiro kobayashi
	public void setName(String name){
		this.name = name;
		
	}
	public String getName(){
		return this.name;
	}
	//2007/11/1 kazuhiro kobayashi
	public boolean hasConnection(){
		//2007/11/19 kazuhiro kobayashi
		return this.connections.size() > 0;
	}
	public void removeConnection(Connection connection){
		this.connections.remove(connection);
	}
	
	public void zombify () {
		Zombie zombie = new Zombie(rw_element.getURI());
		rw_element = zombie;
	}
	
	public boolean isZombified () {
		return rw_element instanceof Zombie;
	}
}
