/* $Id: SearchOperator.java 125 2011-03-09 09:49:51Z ohura $ */
package jp.ac.hokudai.meme.core_smart_gs.test;

import java.awt.Rectangle;
import java.io.*;
import java.util.ArrayList;

import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;
import jp.ac.hokudai.meme.core_smart_gs.searcher.*;

/**
 * @author hajime
 */
public class SearchOperator {
    private final String[] imageExts_ = {"jpg", "png", "bmp"};
    private IDocumentSearcher searcher_ = null;
    private File[] fileList_ = null;
    private QueryRect query = null;
    private ResultRects result_ = null;
    
    public SearchOperator(int type){
//        searcher_ = DocumentSearcher.getInstance(IDocumentSearcher.TYPE_NORMAL);
        searcher_ = DocumentSearcher.getInstance(IDocumentSearcher.TYPE_DTW_1);
    }
    
    public File[] addDscFile(File[] dscFiles) throws IOException{
        File[] addFiles = chkFileList(dscFiles, fileList_);
        try {
        	fileList_ = searcher_.addDscFile(addFiles);
		} catch (InvalidDataFormatException e) {
            System.out.println(e.getMessage());
            if (fileList_ == null) {
            	fileList_ = new File[0];
			}
            return fileList_;
		}
        
        return fileList_;
    }
    
    private File[] chkFileList(File[] dscFiles, File[] fileList) {
        ArrayList retList = new ArrayList();
        if (fileList == null) {
            return dscFiles;
        }
        for (int i = 0; i < dscFiles.length; i++) {
            File file = dscFiles[i];
            boolean rmFlag = false;
            for (int j = 0; j < fileList.length; j++) {
                if (file.equals(fileList[j])) {
                    rmFlag = true; 
                }
            }
            if(!rmFlag){
                retList.add(file);    
            }
        }
        return (File[]) retList.toArray(new File[0]);
    }

    public ResultRects search(){
        result_ = searcher_.search(query);
        return result_;
    }
    
    public boolean hasDscData(){
        return searcher_.hasDscData();
    }
    
    public void switchSeacher(int type) {
       searcher_.switchSeacher(type) ;
    }

    public String getImagePath(int pNum) {
    	
        File targetDscFile = fileList_[pNum];
        File base = targetDscFile.getParentFile();
        String seedName = getBody(targetDscFile.getAbsolutePath());
        String ret = "";
        for (int i = 0; i < imageExts_.length; i++) {
            File target = new File(base.getParent(), seedName + "." + imageExts_[i]);
            if (target.exists()) {
                ret = target.getAbsolutePath();
            }
        }
        return ret;
    }
    
    protected String getExtension(String filename){
        int index = filename.lastIndexOf(".");
        if( index > -1 )
            return filename.substring(index + 1);
        else
            return "";
    }
    
    protected String getBody(String filename){
        String result;

        int index = filename.lastIndexOf(".");
        if( index > -1 )
            result = filename.substring(0, index);
        else
            result = new String(filename);

        index = result.lastIndexOf(File.separator);
        if( index > -1 )
            result = result.substring(index + 1);

        return result;
    }

    /**
     * @param downX
     * @param downY
     * @param upX
     * @param upY
     * @param pageIndex
     * @return
     */
    public boolean setQuery(int downX, int downY, int upX, int upY, int pageIndex) {
        if(downX < 0 || downY < 0 | upX < 0 | upY < 0) return false;
        
        if(downX > upX){
            int tmp = downX;
            downX = upX;
            upX = tmp;
        }
        if(downY > upY){
            int tmp = downY;
            downY = upY;
            upY = tmp;
        }
        
        Rectangle select = new Rectangle(downX, downY, upX - downX, upY - downY);
        PagedRect pRect = new PagedRect(pageIndex, select);
        query = new QueryRect();
        query.addQueryPRect(pRect);
        return true;
    }

    /**
     * @return
     */
    public PagedRect[] confirmQueryRect() {
        return searcher_.rectConfirm(query).getAllRects();
    }

    public int getPageCount() {
        return fileList_.length;
    }

}
